/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.turbospaces.common.MDCUtil;
import com.turbospaces.common.RequestReplyMapper;
import com.turbospaces.common.RequestReplyTimeout;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ConcurrentReferenceHashMap;

public class CompletableRequestReplyMapper<K, V>
extends ThreadPoolTaskScheduler
implements RequestReplyMapper<K, V> {
    private static final Logger log = LoggerFactory.getLogger(CompletableRequestReplyMapper.class);
    private final ConcurrentMap<K, SettableFuture<V>> corr = new ConcurrentReferenceHashMap();

    public CompletableRequestReplyMapper() {
        this.setDaemon(true);
        this.setRemoveOnCancelPolicy(true);
        this.setPoolSize(Runtime.getRuntime().availableProcessors());
    }

    @Override
    public SettableFuture<V> acquire(final K key, final Duration duration) {
        final Map mdc = MDC.getCopyOfContextMap();
        final StopWatch stopWatch = StopWatch.createStarted();
        final SettableFuture toReturn = SettableFuture.create();
        if (Objects.nonNull(this.corr.putIfAbsent(key, toReturn))) {
            toReturn.setException((Throwable)new IllegalArgumentException("duplicate key violation for correlation id: " + key));
        } else {
            final ScheduledFuture timerTask = this.schedule(new Runnable(){

                @Override
                public void run() {
                    SettableFuture tmp = (SettableFuture)CompletableRequestReplyMapper.this.corr.remove(key);
                    if (Objects.nonNull(tmp) && BooleanUtils.isFalse((Boolean)tmp.isDone())) {
                        MDCUtil.propagete(mdc);
                        try {
                            tmp.setException((Throwable)new RequestReplyTimeout(duration, key));
                            log.info("request-reply(m={}) removed subj due to timeout", key);
                        }
                        catch (Exception err) {
                            log.error(err.getMessage(), (Throwable)err);
                        }
                        finally {
                            MDC.clear();
                        }
                    }
                }
            }, Instant.now().plus(duration));
            toReturn.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        log.trace("about to cancel timeout task: {} for key: {}", (Object)timerTask, key);
                        timerTask.cancel(false);
                        toReturn.get();
                        stopWatch.stop();
                        CompletableRequestReplyMapper.this.corr.remove(key);
                        log.debug("request-reply(m={}) completed in {}", key, (Object)stopWatch);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, MoreExecutors.directExecutor());
        }
        return toReturn;
    }

    @Override
    public boolean complete(K key, V value) {
        Objects.requireNonNull(key);
        SettableFuture subj = (SettableFuture)this.corr.remove(key);
        if (Objects.nonNull(subj)) {
            subj.set(value);
            return true;
        }
        log.trace("no such correlation for key: {}", key);
        return false;
    }

    @Override
    public void completeExceptionally(K key, Throwable reason) {
        Objects.requireNonNull(key);
        SettableFuture subj = (SettableFuture)this.corr.remove(key);
        if (Objects.nonNull(subj)) {
            subj.setException(reason);
        }
    }

    @Override
    public void clear() {
        this.corr.clear();
    }

    @Override
    public int pendingCount() {
        return this.corr.size();
    }
}

