package com.turbospaces.executor;

import java.nio.charset.StandardCharsets;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;

public interface WorkUnit {
    String topic();
    int partition();
    long timestamp();
    long offset();
    byte[] key();

    default HashCode hash() {
        Hasher hasher = Hashing.murmur3_32_fixed().newHasher();
        hasher.putString(topic(), StandardCharsets.UTF_8);
        hasher.putInt(partition());
        hasher.putLong(offset());
        if (key() != null) {
            hasher.putBytes(key());
        }
        return hasher.hash();
    }
}
