package com.turbospaces.http;

import com.turbospaces.annotations.NonBlockingCallOnlyGuard;
import com.turbospaces.boot.AbstractBootstrapAware;
import java.lang.reflect.Method;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class NonBlockingCallOnlyAspect extends AbstractBootstrapAware {

    @Around("@within(com.turbospaces.annotations.NonBlockingCallOnlyGuard)")
    public Object guardClass(ProceedingJoinPoint pjp) throws Throwable {
        Method method = ((MethodSignature) pjp.getSignature()).getMethod();
        Class<?> declaringClass = method.getDeclaringClass();
        NonBlockingCallOnlyGuard guard = declaringClass.getAnnotation(NonBlockingCallOnlyGuard.class);

        return perform(pjp, guard, method);
    }

    @Around("execution (@com.turbospaces.annotations.NonBlockingCallOnlyGuard * *.*(..))")
    public Object guardMethod(ProceedingJoinPoint pjp) throws Throwable {
        Method method = ((MethodSignature) pjp.getSignature()).getMethod();
        NonBlockingCallOnlyGuard guard = method.getAnnotation(NonBlockingCallOnlyGuard.class);
        if (Objects.isNull(guard)) {
            method = pjp.getTarget().getClass().getMethod(method.getName(), method.getParameterTypes());
            guard = method.getAnnotation(NonBlockingCallOnlyGuard.class);
        }

        return perform(pjp, guard, method);
    }
    private Object perform(ProceedingJoinPoint pjp, NonBlockingCallOnlyGuard guard, Method method) throws Throwable {
        if (Boolean.TRUE.equals(NonBlockingCallOnlyGuard.NON_BLOCKING_CALL_ONLY_MARKER.get())) {
            logger.error("api abuse detected: {}, blocking remote call in service", pjp.toLongString());
            if (bootstrap.isDevMode()) {
                throw new IllegalStateException(String.format("api abuse detected: %s, blocking remote call in HTTP controller", pjp.toShortString()));
            }
        }
        return pjp.proceed();
    }
}
