/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.executor;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.executor.ContextWorker;
import com.turbospaces.executor.SerialContextWorker;
import com.turbospaces.executor.WorkUnit;
import io.netty.util.AsciiString;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.MDC;
import org.springframework.beans.factory.DisposableBean;

public class ThreadPoolContextWorker
extends AbstractBootstrapAware
implements ContextWorker,
DisposableBean {
    private final LoadingCache<AsciiString, SerialContextWorker> executors;
    private final ExecutorService executor;

    public ThreadPoolContextWorker(final ExecutorService executor) {
        this.executor = Objects.requireNonNull(executor);
        this.executors = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<AsciiString, SerialContextWorker>(){

            public SerialContextWorker load(AsciiString key) {
                return new SerialContextWorker(key, executor);
            }
        });
    }

    @Override
    public ContextWorker forKey(WorkUnit unit) {
        AsciiString partitionKey = new AsciiString(unit.key());
        return (ContextWorker)this.executors.getUnchecked((Object)partitionKey);
    }

    @Override
    public void execute(Runnable command) {
        Map mdcContextMap = MDC.getCopyOfContextMap();
        this.executor.execute(this.wrapRunnable(command, mdcContextMap));
    }

    public void destroy() throws Exception {
        StopWatch stopWatch = StopWatch.createStarted();
        Duration timeout = (Duration)this.bootstrap.props().APP_PLATFORM_GRACEFUL_SHUTDOWN_TIMEOUT.get();
        List<Runnable> never = PlatformUtil.shutdownExecutor(this.executor, timeout);
        stopWatch.stop();
        this.logger.debug("stopped kafka-worker in {}. {} task(s) were never executed ...", (Object)stopWatch, (Object)never.size());
    }
}

