/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckFilter;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.turbospaces.boot.AbstractHealtchCheck;
import com.turbospaces.boot.PlatformExecutorService;
import com.turbospaces.boot.PlatformScheduledExecutorService;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.SSL;
import com.turbospaces.common.SelfSignedCertificateGenerator;
import com.turbospaces.executor.DefaultPlatformExecutorService;
import com.turbospaces.ups.UPSs;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import io.opentracing.Tracer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.security.KeyStore;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.springframework.cloud.DynamicCloud;
import org.springframework.cloud.SmartCloud;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.context.ConfigurableApplicationContext;
import reactor.core.publisher.Flux;

public interface Bootstrap
extends SmartCloud,
UPSs {
    public ConfigurableApplicationContext run(String ... var1);

    public void shutdown() throws Exception;

    public void exit(int var1);

    public DynamicCloud cloud();

    public String spaceName();

    public String appId();

    public String release();

    public boolean isDevMode();

    default public boolean isProdMode() {
        return BooleanUtils.isFalse((Boolean)this.isDevMode());
    }

    public PlatformScheduledExecutorService globalPlatform();

    public PlatformExecutorService platform(String var1);

    public Map<String, DefaultPlatformExecutorService> platforms();

    public ApplicationProperties props();

    public ApplicationConfig cfg();

    public KeyStore keyStore();

    public Tracer tracer();

    public void refreshCfg() throws Exception;

    public void squashLogging() throws Exception;

    public int port();

    public int secondaryPort();

    public int tertiaryPort();

    public MetricRegistry metricRegistry();

    public MeterRegistry meterRegistry();

    public void registerHealthCheck(String var1, HealthCheck var2);

    public HealthCheckRegistry healthCheckRegistry();

    public RetryRegistry retryRegistry();

    public RateLimiterRegistry rateLimiterRegistry();

    public TimeLimiterRegistry timeLimiterRegistry();

    @Override
    default public void addUps(ServiceInfo info) {
        this.cloud().addUps(info);
    }

    @Override
    default public boolean removeUps(String id) {
        return this.cloud().removeUps(id);
    }

    @Override
    default public boolean removeUps(ServiceInfo si) {
        return this.cloud().removeUps(si);
    }

    @Override
    default public <T extends ServiceInfo> Flux<ServiceInfo> serviceInfoByName(String ups) {
        return this.cloud().serviceInfoByName(ups);
    }

    @Override
    default public <T extends ServiceInfo> Flux<ServiceInfo> scopedServiceInfoByName(String scope, String name) {
        return this.cloud().scopedServiceInfoByName(scope, name);
    }

    default public SortedMap<String, HealthCheck.Result> healthCheck() {
        return this.healthCheckRegistry().runHealthChecks(new HealthCheckFilter(){

            public boolean matches(String name, HealthCheck healthCheck) {
                if (healthCheck instanceof AbstractHealtchCheck) {
                    AbstractHealtchCheck check = (AbstractHealtchCheck)healthCheck;
                    return check.isPermanent();
                }
                return true;
            }
        });
    }

    default public void createSelfSignedKeyStoreIfAbsent(File file) throws Exception {
        this.createSelfSignedKeyStoreIfAbsent(file, SelfSignedCertificateGenerator.PASSWORD);
    }

    default public void createSelfSignedKeyStoreIfAbsent(File file, String password) throws Exception {
        if (!file.exists()) {
            SelfSignedCertificateGenerator ssc = new SelfSignedCertificateGenerator();
            ssc.setBootstrap(this);
            KeyStore keystore = ssc.call();
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                keystore.store(out, password.toCharArray());
                FileUtils.writeByteArrayToFile((File)file, (byte[])out.toByteArray());
            }
        }
    }

    default public Optional<SSLContext> generateSelfSignedCertificate() throws Exception {
        if (((Boolean)this.props().APP_USE_SELF_SIGNED_CERTIFICATE.get()).booleanValue() && this.isDevMode()) {
            File keystoreFile = new File(FileUtils.getUserDirectory().getAbsolutePath() + "/self_signed_keystore");
            this.createSelfSignedKeyStoreIfAbsent(keystoreFile);
            SSL ssl = new SSL();
            ssl.loadKeyStore(keystoreFile, SelfSignedCertificateGenerator.PASSWORD);
            return Optional.of(ssl.build());
        }
        return Optional.empty();
    }
}

