/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicReference;

public class AtomicBigDecimal {
    private final AtomicReference<BigDecimal> holder = new AtomicReference();

    public AtomicBigDecimal() {
        this.holder.set(BigDecimal.ZERO);
    }

    public AtomicBigDecimal(BigDecimal value) {
        this.holder.set(value);
    }

    public BigDecimal get() {
        return this.holder.get();
    }

    public BigDecimal addAndGet(BigDecimal value) {
        BigDecimal next;
        BigDecimal current;
        while (!this.holder.compareAndSet(current = this.holder.get(), next = current.add(value))) {
        }
        return next;
    }

    public BigDecimal subtractAndGet(BigDecimal value) {
        BigDecimal next;
        BigDecimal current;
        while (!this.holder.compareAndSet(current = this.holder.get(), next = current.subtract(value))) {
        }
        return next;
    }

    public BigDecimal multiplyAndGet(BigDecimal value) {
        BigDecimal next;
        BigDecimal current;
        while (!this.holder.compareAndSet(current = this.holder.get(), next = current.multiply(value))) {
        }
        return next;
    }

    public BigDecimal divideAndGet(BigDecimal value) {
        BigDecimal next;
        BigDecimal current;
        while (!this.holder.compareAndSet(current = this.holder.get(), next = current.divide(value))) {
        }
        return next;
    }
}

