package com.turbospaces.executor;

import java.time.Duration;
import java.util.concurrent.CountDownLatch;

import org.junit.jupiter.api.Test;

import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;

import io.vavr.CheckedRunnable;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ConfigurablePlatformTest {
    @Test
    public void works() throws Exception {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        cfg.setLocalProperty(props.APP_PLATFORM_GRACEFUL_SHUTDOWN_TIMEOUT.getKey(), Duration.ofSeconds(1));

        SimpleBootstrap bootstrap = new SimpleBootstrap(props);
        bootstrap.run();

        DefaultPlatformExecutorService platform = new DefaultPlatformExecutorService("test", 1, 2);
        platform.setBootstrap(bootstrap);
        platform.afterPropertiesSet();

        try {
            CountDownLatch semaphore = new CountDownLatch(1);
            CountDownLatch l = new CountDownLatch(1);
            CountDownLatch interrupted = new CountDownLatch(1);
            platform.submit(new CheckedRunnable() {
                @Override
                public void run() throws Exception {
                    System.out.println(Thread.currentThread().getName() + " ::: work");
                    semaphore.await();
                    l.countDown();
                }
            });
            platform.execute(new Runnable() {
                @Override
                public void run() {
                    System.out.println(Thread.currentThread().getName() + " ::: execute");
                    semaphore.countDown();
                }
            });
            l.await();
            CountDownLatch started = new CountDownLatch(1);
            platform.submit(new CheckedRunnable() {
                @Override
                public void run() {
                    synchronized (this) {
                        try {
                            log.debug("about to hang forever ...");
                            Thread.sleep(1000);
                            log.debug("count down to mark started ...");
                            started.countDown();
                            wait();
                        } catch (InterruptedException err) {
                            interrupted.countDown();
                        }
                    }
                }
            });
            started.await();
            platform.destroy();
            interrupted.await();
        } finally {
            bootstrap.shutdown();
        }
    }
}
