package com.turbospaces.common;

import java.time.Duration;

import com.google.common.util.concurrent.SettableFuture;

public interface RequestReplyMapper<K, V> {
    SettableFuture<V> acquire(K corrId, Duration duration);
    boolean complete(K corrId, V value);
    void completeExceptionally(K corrId, Throwable reason);
    void clear();
    int pendingCount();
}
