/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ups;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.turbospaces.common.PlatformUtil;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.service.BaseServiceInfo;

public class ZookeeperServiceInfo
extends BaseServiceInfo {
    public static final String ZK_SCHEME = "zk";
    private List<String> nodes = new LinkedList<String>();
    private int port = 9092;

    public ZookeeperServiceInfo(String id, URI uri) {
        super(id);
        if (ZK_SCHEME.equals(uri.getScheme())) {
            Map.Entry<List<String>, Integer> entry = PlatformUtil.parseNodesAndPort(uri);
            this.nodes = entry.getKey();
            this.port = entry.getValue();
        }
    }

    public List<String> getNodes() {
        return this.nodes;
    }

    public int getPort() {
        return this.port;
    }

    public String toConnnectionString() {
        return Joiner.on((char)',').join(Iterables.transform(this.nodes, (Function)new Function<String, String>(){

            public String apply(String input) {
                return String.format("%s:%s", input, ZookeeperServiceInfo.this.port);
            }
        }));
    }

    public String toString() {
        return String.format("%s://%s:%s", ZK_SCHEME, StringUtils.join(this.getNodes(), (char)','), this.getPort());
    }
}

