/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.ups;

import com.google.common.net.HostAndPort;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.ups.PlainServiceInfo;
import com.turbospaces.ups.ZookeeperServiceInfo;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudConnector;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.service.UriBasedServiceInfo;
import org.springframework.cloud.service.common.CassandraServiceInfo;

public interface UPSs {
    public static final String CFG = "cfg";
    public static final String ZOOKEEPER = "zookeeper";
    public static final String KAFKA = "kafka";
    public static final String JAEGER = "jaeger";
    public static final String SENTRY = "sentry";
    public static final String ELASTIC_SEARCH = "elastic-search";
    public static final String REDIS = "redis";
    public static final String CASSANDRA = "cassandra";
    public static final String GRAPHITE = "graphite";
    public static final String INFLUX_DB = "influx-db";
    public static final String WEB3J = "web3j";
    public static final String WEB3J_CREDENTIALS = "web3j-credentials";
    public static final String MYSQL_OWNER = "mysql-owner";
    public static final String MYSQL_APP = "mysql-app";
    public static final String ORACLE_OWNER = "oracle-owner";
    public static final String ORACLE_APP = "oracle-app";
    public static final String POSTGRES_OWNER = "postgres-owner";
    public static final String POSTGRES_APP = "postgres-app";
    public static final String QUARTZ_OWNER = "quartz-owner";
    public static final String QUARTZ_APP = "quartz-app";
    public static final String H2_OWNER = "h2-owner";
    public static final String H2_APP = "h2-app";
    public static final String JOB_MANAGER = "job-manager";
    public static final String TASK_MANAGER = "task-manager";
    public static final String FRONTEND_SERVER = "frontend-server";
    public static final String SERVER = "server";
    public static final String GATEWAY = "gateway";
    public static final String FRONTEND_UI = "frontend-ui";
    public static final String PUSH_SERVER = "push-server";
    public static final String SENDGRID = "sendgrid";
    public static final String MAILCHIMP = "mailchimp";
    public static final String WORLDPAY = "worldpay";
    public static final String PAYPAL = "paypal";
    public static final String GOOGLE_PAY = "google-pay";
    public static final String GOOGLE_PLAY = "google-play";
    public static final String FACEBOOK = "facebook";
    public static final String INSTAGRAM = "instagram";
    public static final String GOOGLE = "google";
    public static final String SLACK = "slack";

    public static <T extends ServiceInfo> Optional<T> findServiceInfoByType(Cloud cloud, final Class<T> serviceInfoClass) {
        List serviceInfos = cloud.getServiceInfos();
        List l = serviceInfos.stream().filter(new Predicate<ServiceInfo>(){

            @Override
            public boolean test(ServiceInfo input) {
                return input.getClass().equals(serviceInfoClass);
            }
        }).collect(Collectors.toList());
        Iterator it = l.iterator();
        if (it.hasNext()) {
            ServiceInfo next = (ServiceInfo)it.next();
            if (it.hasNext()) {
                throw new IllegalArgumentException("unable to find unique service by type");
            }
            return Optional.of(next);
        }
        return Optional.empty();
    }

    public static <T extends ServiceInfo> T findRequiredServiceInfoByType(Bootstrap boot, Class<T> serviceInfoClass) {
        return (T)((ServiceInfo)UPSs.findServiceInfoByType(boot.cloud(), serviceInfoClass).get());
    }

    public static <T extends ServiceInfo> T findRequiredServiceInfoByType(Cloud cloud, Class<T> serviceInfoClass) {
        return (T)((ServiceInfo)UPSs.findServiceInfoByType(cloud, serviceInfoClass).get());
    }

    public static <T extends ServiceInfo> Optional<T> findServiceInfoByName(List<ServiceInfo> serviceInfos, final String name) {
        return serviceInfos.stream().filter(new Predicate<ServiceInfo>(){

            @Override
            public boolean test(ServiceInfo input) {
                return input.getId().equals(name);
            }
        }).findAny();
    }

    public static <T extends ServiceInfo> Optional<T> findScopedServiceInfoByName(String scope, Bootstrap bootstrap, String name) {
        Optional<T> opt = UPSs.findServiceInfoByName(bootstrap, scope + "-" + name);
        if (opt.isPresent()) {
            return opt;
        }
        opt = UPSs.findServiceInfoByName(bootstrap.cloud(), name);
        return opt;
    }

    public static <T extends ServiceInfo> Optional<T> findServiceInfoByName(Bootstrap boot, String name) {
        List serviceInfos = boot.cloud().getServiceInfos();
        return UPSs.findServiceInfoByName(serviceInfos, name);
    }

    public static <T extends ServiceInfo> Optional<T> findServiceInfoByName(Cloud cloud, String name) {
        List serviceInfos = cloud.getServiceInfos();
        return UPSs.findServiceInfoByName(serviceInfos, name);
    }

    public static <T extends ServiceInfo> Optional<T> findServiceInfoByName(CloudConnector connector, String name) {
        List serviceInfos = connector.getServiceInfos();
        return UPSs.findServiceInfoByName(serviceInfos, name);
    }

    public static <T extends ServiceInfo> T findScopedRequiredServiceInfoByName(String scope, Bootstrap bootstrap, String name) {
        Optional<T> opt = UPSs.findServiceInfoByName(bootstrap, scope + "-" + name);
        if (opt.isPresent()) {
            return (T)((ServiceInfo)opt.get());
        }
        opt = UPSs.findServiceInfoByName(bootstrap.cloud(), name);
        return (T)((ServiceInfo)opt.get());
    }

    public static <T extends ServiceInfo> T findRequiredServiceInfoByName(Bootstrap bootstrap, String name) {
        return (T)((ServiceInfo)UPSs.findServiceInfoByName(bootstrap.cloud(), name).get());
    }

    public static <T extends ServiceInfo> T findRequiredServiceInfoByName(Cloud cloud, String name) {
        return (T)((ServiceInfo)UPSs.findServiceInfoByName(cloud, name).get());
    }

    public static ApplicationConfig addUserProvideServices(ApplicationConfig cfg, List<ServiceInfo> services) {
        Properties props = new Properties();
        UPSs.addUserProvideServices(props, services);
        cfg.setLocalProperties(props);
        return cfg;
    }

    public static Properties addUserProvideServices(Properties props, List<ServiceInfo> services) {
        for (ServiceInfo info : services) {
            String uri = null;
            if (info instanceof UriBasedServiceInfo) {
                uri = ((UriBasedServiceInfo)info).getUri();
            } else if (info instanceof ZookeeperServiceInfo) {
                uri = ((ZookeeperServiceInfo)info).toString();
            } else if (info instanceof CassandraServiceInfo) {
                uri = ((CassandraServiceInfo)info).toString();
            } else {
                throw new IllegalArgumentException();
            }
            props.put("service." + info.getId() + ".uri", uri);
        }
        return props;
    }

    public static PlainServiceInfo toKafkaServiceInfo(HostAndPort addr) {
        while (true) {
            try {
                String uri = String.format("kafka://%s:%d", addr.getHost(), addr.getPort());
                PlainServiceInfo info = new PlainServiceInfo(KAFKA, uri);
                return info;
            }
            catch (Exception err) {
                ExceptionUtils.wrapAndThrow((Throwable)err);
                continue;
            }
            break;
        }
    }

    public static ZookeeperServiceInfo toZookeeperServiceInfo(HostAndPort addr) {
        while (true) {
            try {
                URI uri = new URI(String.format("zk://%s:%d", addr.getHost(), addr.getPort()));
                ZookeeperServiceInfo info = new ZookeeperServiceInfo(ZOOKEEPER, uri);
                return info;
            }
            catch (Exception err) {
                ExceptionUtils.wrapAndThrow((Throwable)err);
                continue;
            }
            break;
        }
    }

    public static PlainServiceInfo toWeb3jServiceInfo(HostAndPort addr) {
        PlainServiceInfo info = new PlainServiceInfo(WEB3J, String.format("http://%s:%s", addr.getHost(), addr.getPort()));
        return info;
    }

    public static CassandraServiceInfo toCassandraServiceInfo(HostAndPort addr) {
        final List<String> peer = Collections.singletonList(addr.getHost());
        CassandraServiceInfo info = new CassandraServiceInfo(CASSANDRA, peer, addr.getPort()){

            public String toString() {
                return String.format("%s://%s:%s", UPSs.CASSANDRA, StringUtils.join((Iterable)peer, (char)','), this.getPort());
            }
        };
        return info;
    }
}

