/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.di;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.TypeListener;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapPlugin;
import com.turbospaces.di.AbstractGuiceDiEngine;
import java.util.ArrayList;

public interface DiEngine {
    public Injector configure(Bootstrap var1) throws Exception;

    public Object injector();

    public void up() throws Exception;

    public void down() throws Exception;

    public void injectMembers(Object var1);

    public <T> T getInstance(Class<T> var1);

    public static abstract class Utils {
        public static Injector createInternalInjector(final Bootstrap bootstrap) {
            Stage stage = Stage.PRODUCTION;
            if (bootstrap.isDevMode()) {
                stage = Stage.DEVELOPMENT;
            }
            ArrayList<Object> l = new ArrayList<Object>();
            for (BootstrapPlugin plugin : bootstrap.plugins()) {
                l.add(plugin);
            }
            l.add(new Module(){

                public void configure(Binder binder) {
                    binder.bindListener(Matchers.any(), (TypeListener)new AbstractGuiceDiEngine.BootstapAwareTypeListener(bootstrap));
                }
            });
            return Guice.createInjector((Stage)stage, l);
        }

        private Utils() {
        }
    }
}

