/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.di;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;
import com.turbospaces.di.DiEngine;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGuiceDiEngine
implements DiEngine {
    protected List<Module> modules;
    protected Injector parent;
    protected Injector injector;

    public AbstractGuiceDiEngine(Iterable<Module> modules) {
        this.modules = ImmutableList.copyOf(modules);
    }

    @Override
    public Object injector() {
        return this.injector;
    }

    @Override
    public void injectMembers(Object obj) {
        this.injector.injectMembers(obj);
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        return (T)this.injector.getInstance(type);
    }

    public Injector createChildInjector(Module diModule) {
        return this.injector.createChildInjector(new Module[]{diModule});
    }

    public static final class BootstapAwareTypeListener
    implements TypeListener {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final Bootstrap bootstrap;

        public BootstapAwareTypeListener(Bootstrap bootstrap) {
            this.bootstrap = bootstrap;
        }

        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            this.logger.debug("checking type = {} ...", type);
            for (Class clazz = type.getRawType(); clazz != null; clazz = clazz.getSuperclass()) {
                if (!BootstrapAware.class.isAssignableFrom(clazz)) continue;
                encounter.register(new MembersInjector<I>(){

                    public void injectMembers(I i) {
                        try {
                            ((BootstrapAware)i).setBootstrap(bootstrap);
                        }
                        catch (Exception err) {
                            ExceptionUtils.wrapAndThrow((Throwable)err);
                        }
                    }
                });
                break;
            }
        }
    }
}

