package com.turbospaces.ups;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Map.Entry;

import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.service.BaseServiceInfo;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.turbospaces.common.PlatformUtil;

public class ZookeeperServiceInfo extends BaseServiceInfo {
    public static final String ZK_SCHEME = "zk";

    private List<String> nodes = new LinkedList<>();
    private int port = 9092;

    public ZookeeperServiceInfo(String id, URI uri) {
        super( id );

        if ( ZK_SCHEME.equals( uri.getScheme() ) ) {
            Entry<List<String>, Integer> entry = PlatformUtil.parseNodesAndPort( uri );
            nodes = entry.getKey();
            port = entry.getValue();
        }
    }
    public List<String> getNodes() {
        return nodes;
    }
    public int getPort() {
        return port;
    }
    public String toConnnectionString() {
        return Joiner.on( ',' ).join( Iterables.transform( nodes, new Function<String, String>() {
            @Override
            public String apply(final String input) {
                return String.format( "%s:%s", input, port );
            }
        } ) );
    }
    @Override
    public String toString() {
        return String.format( "%s://%s:%s", ZK_SCHEME, StringUtils.join( getNodes(), ',' ), getPort() );
    }
}
