package com.turbospaces.di;

import java.util.Arrays;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;

public class GuiceDiEngine extends AbstractGuiceDiEngine {
    private GuiceDiEngine(Iterable<Module> modules) {
        super( modules );
    }
    @Override
    public Injector configure(Bootstrap bootstrap) throws Exception {
        for ( Module m : modules ) {
            if ( m instanceof BootstrapAware ) {
                ( (BootstrapAware) m ).setBootstrap( bootstrap );
            }
        }

        parent = DiEngine.Utils.createInternalInjector( bootstrap );
        return parent;
    }
    @Override
    public void up() throws Exception {
        injector = parent.createChildInjector( modules );
    }
    @Override
    public void down() throws Exception {
        // NO-OP (not much we can do without governator)
    }
    public static GuiceDiEngine create(Module... modules) {
        GuiceDiEngine engine = new GuiceDiEngine( Arrays.asList( modules ) );
        return engine;
    }
}
