package com.turbospaces.di;

import java.util.ArrayList;
import java.util.List;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.matcher.Matchers;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapPlugin;
import com.turbospaces.di.AbstractGuiceDiEngine.BootstapAwareTypeListener;

public interface DiEngine {
    Injector configure(Bootstrap bootstrap) throws Exception;
    Object injector();
    void up() throws Exception;
    void down() throws Exception;
    //
    // helper methods
    //
    void injectMembers(Object obj);
    <T> T getInstance(Class<T> type);

    public static abstract class Utils {
        public static Injector createInternalInjector(Bootstrap bootstrap) {
            Stage stage = Stage.PRODUCTION;
            if ( bootstrap.isDevMode() ) {
                stage = Stage.DEVELOPMENT;
            }

            List<Module> l = new ArrayList<>();
            for ( BootstrapPlugin plugin : bootstrap.plugins() ) {
                l.add( plugin );
            }
            l.add( new Module() {
                @Override
                public void configure(Binder binder) {
                    binder.bindListener( Matchers.any(), new BootstapAwareTypeListener( bootstrap ) );
                }
            } );

            return Guice.createInjector( stage, l );
        }
        private Utils() {}
    }
}
