package com.turbospaces.di;

import java.util.List;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;

public abstract class AbstractGuiceDiEngine implements DiEngine {
    protected List<Module> modules;
    protected Injector parent, injector;

    public AbstractGuiceDiEngine(Iterable<Module> modules) {
        this.modules = ImmutableList.copyOf( modules );
    }
    @Override
    public Object injector() {
        return injector;
    }
    @Override
    public void injectMembers(Object obj) {
        injector.injectMembers( obj );
    }
    @Override
    public <T> T getInstance(Class<T> type) {
        return injector.getInstance( type );
    }
    public Injector createChildInjector(Module diModule) {
        return injector.createChildInjector( diModule );
    }

    public static final class BootstapAwareTypeListener implements TypeListener {
        private final Logger logger = LoggerFactory.getLogger( getClass() );
        private final Bootstrap bootstrap;

        public BootstapAwareTypeListener(Bootstrap bootstrap) {
            this.bootstrap = bootstrap;
        }
        @Override
        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            logger.debug( "checking type = {} ...", type );
            Class<?> clazz = type.getRawType();
            while ( clazz != null ) {
                if ( BootstrapAware.class.isAssignableFrom( clazz ) ) {
                    encounter.register( new MembersInjector<I>() {
                        @Override
                        public void injectMembers(I i) {
                            try {
                                ( (BootstrapAware) i ).setBootstrap( bootstrap );
                            }
                            catch ( Exception err ) {
                                ExceptionUtils.wrapAndThrow( err );
                            }
                        }
                    } );
                    break;
                }
                clazz = clazz.getSuperclass();
            }
        }
    }
}
