package com.turbospaces.cfg;

import java.io.IOException;
import java.util.List;
import java.util.Properties;

import com.netflix.archaius.api.Property;
import com.netflix.archaius.api.config.CompositeConfig;
import com.netflix.archaius.api.exceptions.ConfigException;

public interface DynamicCompositeConfig extends CompositeConfig {
    //
    // source names
    //
    String GIT_CFG_NAME = "core.GIT_CFG";
    String SYSTEM_PROPS_CFG_NAME = "core.SYSTEM_PROPS_CFG";
    String SYSTEM_ENV_CFG_NAME = "core.ENV_PROPS_CFG";
    String CMD_LINE_CFG_NAME = "core.CMD_LINE_CFG";
    String LOCAL_CFG_NAME = "core.LOCAL_APPLICATION_CFG";
    String CLOUD_CFG_NAME = "core.CLOUD_CFG";
    String LEGACY_CFG_NAME = "core.LEGACY_CFG";
    String DEFAULT_APP_CFG_NAME = "core.DEFAULT_APP_CFG";

    // dynamic factory
    DynamicPropertyFactory factory();

    //
    // utility methods to work with lists
    //
    List<String> getStringList(Property<String> prop);
    List<Integer> getIntList(Property<Integer> prop);
    List<Long> getLongList(Property<Long> prop);

    //
    // utility method for working with sources
    //
    void clearLocalProperty(String key);
    void setLocalProperty(String key, Object value);
    void setLocalProperties(Properties props);
    void clearGitProperty(String key);
    void setGitProperty(String key, Object value);
    void setGitProperties(Properties props);
    void clearCmdLineParams(String key);
    void setCmdLineParams(String key, Object value);
    void setCmdLineParams(Properties props);
    void clearDefaultProperty(String key);
    void setDefaultProperty(String key, Object value);
    void setDefaultProperties(Properties props);
    void clearAllDefaultProperties() throws ConfigException;

    //
    // utility methods to load local development properties
    //
    DynamicCompositeConfig loadDefaultPropsFromResource(String resourceName) throws IOException;
    DynamicCompositeConfig loadLocalDevProperties(String username) throws Exception;
    DynamicCompositeConfig loadLocalDevProperties() throws Exception;
}
