package com.turbospaces.boot;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

import com.turbospaces.common.ThrowableAction;
import com.turbospaces.di.PreDestroyable;

import reactor.core.Disposable;
import reactor.core.scheduler.Scheduler;

public interface Platform extends ExecutorService, PreDestroyable, Scheduler {
    void work(ThrowableAction action);
    Disposable schedulePeriodically(ThrowableAction action, long initialDelay, long period, TimeUnit unit);
}
