package com.turbospaces.boot;

import com.google.inject.Binder;
import com.google.inject.Module;

public interface BootstrapPlugin extends Module {
    /**
     * configure corresponding bootstrap bindings using {@link com.google.inject.Provides}} or by registering providers
     * directly. Injections are supported directly into instance. Every single binding exposed by plugin
     * will be available to main guice injector (at later stage once all health-checks are passing and all inbound
     * channels are initialized). All binding from all bootstrap plugins will be source(parent) for
     * main(child) injector.
     * </p>
     *
     * Most trivial use-case <code>binder.bind( Foo.class ).toProvider( this ).asEagerSingleton();</code>
     */
    @Override
    void configure(Binder binder);
}
