package com.turbospaces.boot;

import java.security.KeyStore;
import java.util.Collection;
import java.util.Date;

import org.springframework.cloud.Cloud;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.di.DiEngine;

import io.micrometer.core.instrument.MeterRegistry;
import io.opentracing.Tracer;
import io.sentry.SentryClient;

public interface Bootstrap {
    //
    // life-cycle
    //
    void start(DiEngine engine) throws Throwable;
    void shutdown() throws Throwable;

    //
    // meta
    //
    ApplicationStatus status();
    Date startedAt();

    boolean isDevMode();
    String release();
    String spaceName();
    String appId();

    KeyStore keyStore();

    //
    // main port
    //
    int port();

    //
    // health-checks and metrics support
    //
    MetricRegistry metricRegistry();
    MeterRegistry meterRegisry();
    HealthCheckRegistry healthCheckRegistry();
    SentryClient sentry();
    Tracer tracer();

    //
    // thread-pool / configuration / cloud / DI engine
    //
    Platform platform();
    ApplicationProperties props();
    Cloud cloud();
    DiEngine diEngine();

    //
    // plugins + channels
    //
    boolean addPlugin(BootstrapPlugin plugin);
    boolean addChannel(Channel acceptor);
    Collection<BootstrapPlugin> plugins();
    Collection<Channel> channels();


    //
    // helper-methods
    //
    boolean isHealthy();
    void registerHealthCheck(String name, HealthCheck check);
}
