/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.healthchecks;

import com.codahale.metrics.health.HealthCheck;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.DisposableHealtchCheck;
import com.turbospaces.cassandra.CassandraSession;
import com.turbospaces.ups.UPSs;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.service.common.CassandraServiceInfo;

public class CassandraHealthCheck
extends DisposableHealtchCheck {
    private final Logger logger = LoggerFactory.getLogger(CassandraSession.class);
    private final Cluster cluster;

    public CassandraHealthCheck(Bootstrap boot) {
        this((CassandraServiceInfo)UPSs.findRequiredServiceInfoByType((Bootstrap)boot, CassandraServiceInfo.class));
    }

    public CassandraHealthCheck(Cloud cloud) {
        this((CassandraServiceInfo)UPSs.findRequiredServiceInfoByType((Cloud)cloud, CassandraServiceInfo.class));
    }

    public CassandraHealthCheck(final CassandraServiceInfo info) {
        final Cluster.Builder builder = Cluster.builder();
        info.getContactPoints().forEach(new Consumer<String>(){

            @Override
            public void accept(String contactPoint) {
                InetSocketAddress addr = new InetSocketAddress(contactPoint, info.getPort());
                builder.addContactPointsWithPorts(new InetSocketAddress[]{addr});
            }
        });
        this.cluster = builder.build();
    }

    protected HealthCheck.Result check() throws Exception {
        HealthCheck.Result result;
        block8: {
            Session session = this.cluster.connect();
            try {
                result = HealthCheck.Result.healthy((String)("connected hosts: " + session.getState().getConnectedHosts()));
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception err) {
                    this.logger.warn(err.getMessage(), (Throwable)err);
                    return HealthCheck.Result.unhealthy((Throwable)err);
                }
            }
            session.close();
        }
        return result;
    }

    public void preDestroy() throws Exception {
        this.cluster.close();
    }
}

