/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SocketOptions;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.ups.UPSs;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.service.common.CassandraServiceInfo;

public abstract class CassandraUtil {
    public static Cluster cluster(ApplicationProperties props, Cloud cloud) {
        CassandraServiceInfo serviceInfo = (CassandraServiceInfo)UPSs.findRequiredServiceInfoByType((Cloud)cloud, CassandraServiceInfo.class);
        return CassandraUtil.cluster(props, serviceInfo);
    }

    public static Cluster cluster(ApplicationProperties props, final CassandraServiceInfo serviceInfo) {
        final Cluster.Builder builder = Cluster.builder();
        serviceInfo.getContactPoints().forEach(new Consumer<String>(){

            @Override
            public void accept(String contactPoint) {
                builder.addContactPointsWithPorts(new InetSocketAddress[]{new InetSocketAddress(contactPoint, serviceInfo.getPort())});
            }
        });
        if (StringUtils.isNotEmpty((CharSequence)serviceInfo.getUsername()) && StringUtils.isNotEmpty((CharSequence)serviceInfo.getPassword())) {
            builder.withCredentials(serviceInfo.getUsername(), serviceInfo.getPassword());
        }
        SocketOptions sopts = new SocketOptions().setKeepAlive(((Boolean)props.TCP_KEEP_ALIVE.get()).booleanValue()).setReuseAddress(((Boolean)props.TCP_REUSE_ADDRESS.get()).booleanValue()).setTcpNoDelay(((Boolean)props.TCP_NODELAY.get()).booleanValue()).setConnectTimeoutMillis((int)TimeUnit.SECONDS.toMillis(((Integer)props.TCP_CONNECTION_TIMEOUT.get()).intValue()));
        builder.withSocketOptions(sopts);
        QueryOptions qopts = new QueryOptions();
        qopts.setConsistencyLevel(ConsistencyLevel.LOCAL_QUORUM);
        builder.withQueryOptions(qopts);
        return builder.build();
    }

    private CassandraUtil() {
    }
}

