/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.cassandra;

import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.turbospaces.cassandra.CassandraSession;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;

public class DefaultCassandraSession
implements CassandraSession {
    private final Map<String, PreparedStatement> stmts = new ConcurrentHashMap<String, PreparedStatement>();
    private final Session target;

    public DefaultCassandraSession(Session target) {
        this.target = Objects.requireNonNull(target);
    }

    public String getLoggedKeyspace() {
        return this.target.getLoggedKeyspace();
    }

    public Session init() {
        return this.target.init();
    }

    public ListenableFuture<Session> initAsync() {
        return this.target.initAsync();
    }

    public ResultSet execute(String query) {
        return this.target.execute(query);
    }

    public ResultSet execute(String query, Object ... values) {
        return this.target.execute(query, values);
    }

    public ResultSet execute(String query, Map<String, Object> values) {
        return this.target.execute(query, values);
    }

    public ResultSet execute(Statement statement) {
        return this.target.execute(statement);
    }

    public ResultSetFuture executeAsync(String query) {
        return this.target.executeAsync(query);
    }

    public ResultSetFuture executeAsync(String query, Object ... values) {
        return this.target.executeAsync(query, values);
    }

    public ResultSetFuture executeAsync(String query, Map<String, Object> values) {
        return this.target.executeAsync(query, values);
    }

    public ResultSetFuture executeAsync(Statement statement) {
        return this.target.executeAsync(statement);
    }

    public PreparedStatement prepare(String query) {
        PreparedStatement prev;
        PreparedStatement stmt = this.stmts.get(query);
        if (stmt == null && (prev = this.stmts.putIfAbsent(query, stmt = this.target.prepare(query))) != null) {
            stmt = prev;
        }
        return stmt;
    }

    public PreparedStatement prepare(RegularStatement statement) {
        return this.target.prepare(statement);
    }

    public ListenableFuture<PreparedStatement> prepareAsync(final String query) {
        PreparedStatement stmt = this.stmts.get(query);
        if (stmt == null) {
            final ListenableFuture f = this.target.prepareAsync(query);
            f.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        DefaultCassandraSession.this.stmts.putIfAbsent(query, (PreparedStatement)f.get());
                    }
                    catch (InterruptedException | ExecutionException err) {
                        throw new RuntimeException(err);
                    }
                }
            }, MoreExecutors.directExecutor());
            return f;
        }
        return Futures.immediateFuture((Object)stmt);
    }

    public ListenableFuture<PreparedStatement> prepareAsync(RegularStatement statement) {
        return this.target.prepareAsync(statement);
    }

    public CloseFuture closeAsync() {
        return this.target.closeAsync();
    }

    public void close() {
        this.target.close();
    }

    public boolean isClosed() {
        return this.target.isClosed();
    }

    public Cluster getCluster() {
        return this.target.getCluster();
    }

    public Session.State getState() {
        return this.target.getState();
    }
}

