/*
 * Decompiled with CFR 0.152.
 */
package com.turbosapces.aether;

import com.google.common.collect.ImmutableList;
import com.turbosapces.aether.DependencyResolver;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class MavenDependencyResolver
implements DependencyResolver,
InitializingBean,
DisposableBean {
    public static final String DEFAULT_JAVA_SCOPE = "compile";
    public static final String HOME = System.getenv("HOME");
    public static final File DEFAULT_LOCAL_REPOSITORY = new File(HOME, ".m2/repository");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ImmutableList<RemoteRepository> repos;
    private RepositorySystem repositorySystem;
    private DefaultRepositorySystemSession session;

    public MavenDependencyResolver() {
        this(Collections.emptyList());
    }

    public MavenDependencyResolver(List<RemoteRepository> repos) {
        ImmutableList.Builder remoteRepos = ImmutableList.builder();
        remoteRepos.add((Object)new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2").build());
        remoteRepos.addAll(repos);
        this.repos = remoteRepos.build();
    }

    public void afterPropertiesSet() throws Exception {
        this.repositorySystem = this.newRepositorySystem();
        LocalRepository localRepo = new LocalRepository(DEFAULT_LOCAL_REPOSITORY);
        this.session = MavenRepositorySystemUtils.newSession();
        this.session.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)this.session, localRepo));
    }

    public void destroy() throws Exception {
        if (Objects.nonNull(this.session)) {
            this.session.setReadOnly();
        }
    }

    @Override
    public List<Artifact> resolveDependency(Artifact artifact) throws Exception {
        DependencyFilter classpathFlter = DependencyFilterUtils.classpathFilter((String[])new String[]{DEFAULT_JAVA_SCOPE});
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(artifact, DEFAULT_JAVA_SCOPE));
        collectRequest.setRepositories(this.repos);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, classpathFlter);
        DependencyResult dependencyResult = this.repositorySystem.resolveDependencies((RepositorySystemSession)this.session, dependencyRequest);
        ImmutableList.Builder artifacts = ImmutableList.builder();
        for (ArtifactResult artifactResult : dependencyResult.getArtifactResults()) {
            artifacts.add((Object)artifactResult.getArtifact());
        }
        return artifacts.build();
    }

    private RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                MavenDependencyResolver.this.logger.error(exception.getMessage(), exception);
            }
        });
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }
}

