/*
 * Decompiled with CFR 0.152.
 */
package com.tsaplin.autojava.trait;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.tsaplin.autojava.trait.AroundAspect;
import com.tsaplin.autojava.trait.Trait;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@SupportedAnnotationTypes(value={"com.tsaplin.autojava.trait.Trait"})
public class TraitProcessor
extends AbstractProcessor {
    private static final String INTERFACE_SUFFIX = Trait.class.getSimpleName();

    @Override
    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnvironment) {
        try {
            for (TypeElement typeElement : typeElements) {
                for (Element element : roundEnvironment.getElementsAnnotatedWith(typeElement)) {
                    if (element.getKind() != ElementKind.CLASS) continue;
                    TypeElement classElement = (TypeElement)element;
                    PackageElement packageElement = (PackageElement)classElement.getEnclosingElement();
                    TypeSpec.Builder typeBuilder = TypeSpec.interfaceBuilder((String)(classElement.getSimpleName() + INTERFACE_SUFFIX)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Trait.class).addMember("impl", "$T.class", new Object[]{ClassName.get((TypeElement)classElement)}).build());
                    for (TypeMirror typeMirror : classElement.getInterfaces()) {
                        if (typeMirror.toString().equals(AroundAspect.class.getName())) continue;
                        typeBuilder.addSuperinterface(TypeName.get((TypeMirror)typeMirror));
                    }
                    ElementFilter.methodsIn(classElement.getEnclosedElements()).forEach(executableElement -> {
                        if (executableElement.getKind() == ElementKind.METHOD && !executableElement.getModifiers().contains((Object)Modifier.PRIVATE) && !executableElement.getSimpleName().toString().equals("around")) {
                            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)executableElement.getSimpleName().toString()).addExceptions((Iterable)executableElement.getThrownTypes().stream().map(type -> TypeName.get((TypeMirror)type)).collect(Collectors.toList())).returns(TypeName.get((TypeMirror)executableElement.getReturnType())).addModifiers(new Modifier[]{Modifier.DEFAULT, Modifier.PUBLIC});
                            for (VariableElement variableElement : executableElement.getParameters()) {
                                methodBuilder.addParameter(TypeName.get((TypeMirror)variableElement.asType()), variableElement.getSimpleName().toString(), new Modifier[0]);
                            }
                            methodBuilder.addCode("throw new UnsupportedOperationException(\"Stab!!!\");", new Object[0]);
                            typeBuilder.addMethod(methodBuilder.build());
                        }
                    });
                    JavaFile javaFile = JavaFile.builder((String)packageElement.getQualifiedName().toString(), (TypeSpec)typeBuilder.build()).build();
                    javaFile.writeTo(this.processingEnv.getFiler());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

