/*
 * Decompiled with CFR 0.152.
 */
package com.tsaplin.autojava.trait;

import com.tsaplin.autojava.trait.AroundAspect;
import com.tsaplin.autojava.trait.Trait;
import de.icongmbh.oss.maven.plugin.javassist.ClassTransformer;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.build.IClassTransformer;
import javassist.build.JavassistBuildException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;

public class TraitTransformer
extends ClassTransformer
implements IClassTransformer {
    private static final Pattern TRAIT_CLASS_PATTERN = Pattern.compile("Trait\\(impl=(.*).class\\)");

    public void applyTransformations(CtClass ctClass) throws JavassistBuildException {
        try {
            this.transform(ctClass);
        }
        catch (Exception e) {
            throw new JavassistBuildException((Throwable)e);
        }
    }

    public boolean shouldTransform(CtClass ctClass) throws JavassistBuildException {
        return !ctClass.isFrozen() && !ctClass.isInterface() && !ctClass.isAnnotation() && !ctClass.isArray() && !ctClass.isPrimitive();
    }

    public void transform(CtClass ctClass) throws JavassistBuildException {
        try {
            CtClass aroundAspectClass = ctClass.getClassPool().get(AroundAspect.class.getName());
            HashSet<String> addedMethodSignatures = new HashSet<String>();
            HashSet<String> excludedMethodSignatures = new HashSet<String>();
            for (CtClass traitClass : ctClass.getInterfaces()) {
                CtMethod newMethod;
                if (!traitClass.hasAnnotation(Trait.class)) continue;
                String implClassName = this.getImplClassName(traitClass);
                CtClass implClass = traitClass.getClassPool().get(implClassName);
                String implFieldName = implClassName.replace('.', '_');
                ctClass.addField(CtField.make((String)("private final " + implClassName + " " + implFieldName + " = new " + implClassName + "();"), (CtClass)ctClass));
                if (implClass.subtypeOf(aroundAspectClass)) {
                    for (CtMethod method : aroundAspectClass.getDeclaredMethods()) {
                        excludedMethodSignatures.add(method.getSignature());
                    }
                    for (CtMethod method : ctClass.getDeclaredMethods()) {
                        if ((method.getModifiers() & 5) == 0 || addedMethodSignatures.contains(method.getSignature())) continue;
                        String origMethodName = "_" + method.getName() + "_" + traitClass.getName().replace('.', '_');
                        newMethod = CtNewMethod.copy((CtMethod)method, (String)origMethodName, (CtClass)ctClass, null);
                        newMethod.setModifiers(16);
                        for (Object attr : method.getMethodInfo().getAttributes()) {
                            if (!(attr instanceof AnnotationsAttribute)) continue;
                            newMethod.getMethodInfo().addAttribute((AttributeInfo)((AnnotationsAttribute)attr));
                        }
                        ctClass.addMethod(newMethod);
                        StringBuilder sb = new StringBuilder("{");
                        sb.append("java.lang.reflect.Method m = getClass().getDeclaredMethod(\"" + origMethodName + "\", $sig);");
                        sb.append("m.setAccessible(true);");
                        if (method.getReturnType().getName().equals("void")) {
                            sb.append(implFieldName + ".around(new com.tsaplin.autojava.trait.CallableMethodImpl(\"" + method.getName() + "\", m), this, $args);");
                        } else {
                            sb.append("return ($r)" + implFieldName + ".around(new com.tsaplin.autojava.trait.CallableMethodImpl(\"" + method.getName() + "\", m), this, $args);");
                        }
                        sb.append("}");
                        method.setBody(sb.toString());
                        method.addCatch("{ throw $e.getTargetException(); }", ClassPool.getDefault().get("java.lang.reflect.InvocationTargetException"));
                    }
                }
                HashSet<String> delegatedMethods = new HashSet<String>();
                for (CtMethod method : traitClass.getDeclaredMethods()) {
                    if (excludedMethodSignatures.contains(method.getSignature())) continue;
                    delegatedMethods.add(method.getSignature());
                }
                for (CtMethod method : implClass.getDeclaredMethods()) {
                    if (!delegatedMethods.contains(method.getSignature())) continue;
                    newMethod = CtNewMethod.copy((CtMethod)method, (CtClass)ctClass, null);
                    if (method.getReturnType().getName().equals("void")) {
                        newMethod.setBody(implFieldName + "." + method.getName() + "($$);");
                    } else {
                        newMethod.setBody("return " + implFieldName + "." + method.getName() + "($$);");
                    }
                    ctClass.addMethod(newMethod);
                    addedMethodSignatures.add(method.getSignature());
                }
            }
        }
        catch (Exception e) {
            throw new JavassistBuildException((Throwable)e);
        }
    }

    private String getImplClassName(CtClass ctClass) {
        try {
            Annotation ann = (Annotation)ctClass.getAnnotation(Trait.class);
            Matcher matcher = TRAIT_CLASS_PATTERN.matcher(ann.toString());
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new IllegalStateException("Implementation class for trait " + ctClass + " cannot be found");
    }
}

