/*
 * Decompiled with CFR 0.152.
 */
package com.tsaplin.autojava.boundproperty;

import com.tsaplin.autojava.boundproperty.HasBoundProperties;
import com.tsaplin.autojava.boundproperty.PropertySetter;
import de.icongmbh.oss.maven.plugin.javassist.ClassTransformer;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.build.IClassTransformer;
import javassist.build.JavassistBuildException;

public class BoundPropertyTransformer
extends ClassTransformer
implements IClassTransformer {
    private static final String PROPERTY_CHANGE_SUPPORT = "private final java.beans.PropertyChangeSupport propertyChangeSupport = new java.beans.PropertyChangeSupport(this);";
    private static final String ADD_PROPERTY_CHANGE_LISTENER = "public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {\n         this.propertyChangeSupport.addPropertyChangeListener(listener);\n     }";
    private static final String REMOVE_PROPERTY_CHANGE_LISTENER = "public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {\n         this.propertyChangeSupport.removePropertyChangeListener(listener);\n     }";

    public void applyTransformations(CtClass ctClass) throws JavassistBuildException {
        try {
            this.transform(ctClass);
        }
        catch (Exception e) {
            throw new JavassistBuildException((Throwable)e);
        }
    }

    public boolean shouldTransform(CtClass ctClass) throws JavassistBuildException {
        try {
            return ctClass.subtypeOf(ctClass.getClassPool().get(HasBoundProperties.class.getName()));
        }
        catch (NotFoundException notFoundException) {
            return false;
        }
    }

    public void transform(CtClass ctClass) throws JavassistBuildException {
        try {
            ctClass.addField(CtField.make((String)PROPERTY_CHANGE_SUPPORT, (CtClass)ctClass));
            ctClass.addMethod(CtMethod.make((String)ADD_PROPERTY_CHANGE_LISTENER, (CtClass)ctClass));
            ctClass.addMethod(CtMethod.make((String)REMOVE_PROPERTY_CHANGE_LISTENER, (CtClass)ctClass));
            for (CtField field : ctClass.getDeclaredFields()) {
                String setterName = "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                try {
                    CtMethod setter = ctClass.getDeclaredMethod(setterName);
                    if (!setter.hasAnnotation(PropertySetter.class)) continue;
                    setter.addLocalVariable("oldValue", field.getType());
                    setter.insertBefore("oldValue = this." + field.getName() + ";");
                    setter.insertAfter("this.propertyChangeSupport.firePropertyChange(\"" + field.getName() + "\", oldValue, this." + field.getName() + ");");
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new JavassistBuildException((Throwable)e);
        }
    }
}

