/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.clickhouse;

import com.playtika.testcontainer.clickhouse.ClickHouseProperties;
import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;
import org.testcontainers.containers.ClickHouseContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.clickhouse.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={ClickHouseProperties.class})
public class EmbeddedClickHouseBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedClickHouseBootstrapConfiguration.class);
    private static final String CLICKHOUSE_NETWORK_ALIAS = "clickhouse.testcontainer.docker";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="clickhouse")
    ToxiproxyContainer.ContainerProxy clickhouseContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedClickHouse") ClickHouseContainer clickHouseContainer, ClickHouseProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy((GenericContainer)clickHouseContainer, properties.getPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.clickhouse.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.clickhouse.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.clickhouse.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedClickHouseToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started ClickHouse ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"embeddedClickHouse"}, destroyMethod="stop")
    public ClickHouseContainer clickHouseContainer(ConfigurableEnvironment environment, ClickHouseProperties properties, Optional<Network> network) {
        ClickHouseContainer clickHouseContainer = (ClickHouseContainer)((ClickHouseContainer)new ClickHouseContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withInitScript(properties.getInitScriptPath())).withNetworkAliases(new String[]{CLICKHOUSE_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((ClickHouseContainer)clickHouseContainer).withNetwork(arg_0));
        String username = !StringUtils.hasLength((String)properties.getUser()) ? clickHouseContainer.getUsername() : properties.getUser();
        String password = !StringUtils.hasLength((String)properties.getPassword()) ? clickHouseContainer.getPassword() : properties.getPassword();
        clickHouseContainer.addEnv("CLICKHOUSE_USER", username);
        clickHouseContainer.addEnv("CLICKHOUSE_PASSWORD", password == null ? "" : password);
        clickHouseContainer = (ClickHouseContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)clickHouseContainer, (CommonContainerProperties)properties, (Logger)log);
        this.registerClickHouseEnvironment(clickHouseContainer, environment, properties, username, password);
        return clickHouseContainer;
    }

    private void registerClickHouseEnvironment(ClickHouseContainer clickHouseContainer, ConfigurableEnvironment environment, ClickHouseProperties properties, String username, String password) {
        Integer mappedPort = clickHouseContainer.getMappedPort(properties.port);
        String host = clickHouseContainer.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.clickhouse.schema", "default");
        map.put("embedded.clickhouse.host", host);
        map.put("embedded.clickhouse.port", mappedPort);
        map.put("embedded.clickhouse.user", username);
        map.put("embedded.clickhouse.password", password);
        map.put("embedded.clickhouse.networkAlias", CLICKHOUSE_NETWORK_ALIAS);
        map.put("embedded.clickhouse.internalPort", properties.getPort());
        log.info("Started ClickHouse server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedClickHouseInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

