/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.runner;

import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.internal.GeometricDistribution;
import com.pholser.junit.quickcheck.internal.ParameterSampler;
import com.pholser.junit.quickcheck.internal.ParameterTypeContext;
import com.pholser.junit.quickcheck.internal.PropertyParameterContext;
import com.pholser.junit.quickcheck.internal.SeededValue;
import com.pholser.junit.quickcheck.internal.ShrinkControl;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.internal.generator.PropertyParameterGenerationContext;
import com.pholser.junit.quickcheck.internal.sampling.ExhaustiveParameterSampler;
import com.pholser.junit.quickcheck.internal.sampling.TupleParameterSampler;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import com.pholser.junit.quickcheck.runner.NoValuesSatisfiedPropertyAssumptions;
import com.pholser.junit.quickcheck.runner.PropertyFalsified;
import com.pholser.junit.quickcheck.runner.PropertyVerifier;
import com.pholser.junit.quickcheck.runner.Shrinker;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import ru.vyarus.java.generics.resolver.GenericsResolver;
import ru.vyarus.java.generics.resolver.context.MethodGenericsContext;

class PropertyStatement
extends Statement {
    private final FrameworkMethod method;
    private final TestClass testClass;
    private final GeneratorRepository repo;
    private final GeometricDistribution distro;
    private final List<AssumptionViolatedException> assumptionViolations;
    private final Logger logger;
    private int successes;

    PropertyStatement(FrameworkMethod method, TestClass testClass, GeneratorRepository repo, GeometricDistribution distro, Logger logger) {
        this.method = method;
        this.testClass = testClass;
        this.repo = repo;
        this.distro = distro;
        this.assumptionViolations = new ArrayList<AssumptionViolatedException>();
        this.logger = logger;
    }

    public void evaluate() throws Throwable {
        Property marker = (Property)this.method.getAnnotation(Property.class);
        ParameterSampler sampler = this.sampler(marker);
        ShrinkControl shrinkControl = new ShrinkControl(marker);
        MethodGenericsContext generics = GenericsResolver.resolve((Class)this.testClass.getJavaClass(), (Class[])new Class[0]).method(this.method.getMethod());
        List<PropertyParameterGenerationContext> paramContexts = Arrays.stream(this.method.getMethod().getParameters()).map(p -> this.parameterContextFor((Parameter)p, generics)).map(p -> new PropertyParameterGenerationContext((PropertyParameterContext)p, this.repo, this.distro, new SourceOfRandomness(new Random()), sampler)).collect(Collectors.toList());
        Stream<List<SeededValue>> sample = sampler.sample(paramContexts);
        for (List args : sample::iterator) {
            this.property(args, shrinkControl).verify();
        }
        if (this.successes == 0 && !this.assumptionViolations.isEmpty()) {
            throw new NoValuesSatisfiedPropertyAssumptions(this.assumptionViolations);
        }
    }

    private PropertyVerifier property(List<SeededValue> arguments, ShrinkControl shrinkControl) throws InitializationError {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Verifying property {} from {} with these values:", (Object)this.method.getName(), (Object)this.testClass.getName());
            this.logger.debug("{}", (Object)Arrays.deepToString(arguments.toArray()));
        }
        List params = arguments.stream().map(SeededValue::parameter).collect(Collectors.toList());
        Object[] args = arguments.stream().map(SeededValue::value).toArray();
        long[] seeds = arguments.stream().mapToLong(SeededValue::seed).toArray();
        return new PropertyVerifier(this.testClass, this.method, args, seeds, s -> ++this.successes, this.assumptionViolations::add, (e, action) -> {
            if (!shrinkControl.shouldShrink()) {
                shrinkControl.onMinimalCounterexample().handle(args, (Runnable)action);
                throw PropertyFalsified.counterexampleFound(this.method.getName(), args, seeds, e);
            }
            try {
                this.shrink(params, args, seeds, shrinkControl, (AssertionError)e);
            }
            catch (AssertionError ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new AssertionError((Object)ex);
            }
        });
    }

    private void shrink(List<PropertyParameterGenerationContext> params, Object[] args, long[] seeds, ShrinkControl shrinkControl, AssertionError failure) throws Throwable {
        new Shrinker(this.method, this.testClass, failure, shrinkControl).shrink(params, args, seeds);
    }

    private PropertyParameterContext parameterContextFor(Parameter parameter, MethodGenericsContext generics) {
        return new PropertyParameterContext(ParameterTypeContext.forParameter(parameter, generics).allowMixedTypes(true)).annotate(parameter);
    }

    private ParameterSampler sampler(Property marker) {
        switch (marker.mode()) {
            case SAMPLING: {
                return new TupleParameterSampler(marker.trials());
            }
            case EXHAUSTIVE: {
                return new ExhaustiveParameterSampler(marker.trials());
            }
        }
        throw new AssertionError((Object)("Don't recognize mode " + (Object)((Object)marker.mode())));
    }
}

