/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.random;

import com.pholser.junit.quickcheck.internal.Items;
import com.pholser.junit.quickcheck.internal.Ranges;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class SourceOfRandomness {
    private static final BigInteger NANOS_PER_SECOND = BigInteger.valueOf(TimeUnit.SECONDS.toNanos(1L));
    private final Random delegate;
    private long seed;

    public SourceOfRandomness(Random delegate) {
        this.seed = delegate.nextLong();
        this.delegate = delegate;
        delegate.setSeed(this.seed);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Random toJDKRandom() {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOut = new ObjectOutputStream(bytesOut);){
            objectOut.writeObject(this.delegate);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
        try (ObjectInputStream objectIn = new ObjectInputStream(bytesIn);){
            Random random = (Random)objectIn.readObject();
            return random;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        catch (ClassNotFoundException shouldNeverHappen) {
            throw new AssertionError((Object)shouldNeverHappen);
        }
    }

    public boolean nextBoolean() {
        return this.delegate.nextBoolean();
    }

    public void nextBytes(byte[] bytes) {
        this.delegate.nextBytes(bytes);
    }

    public byte[] nextBytes(int count) {
        byte[] buffer = new byte[count];
        this.delegate.nextBytes(buffer);
        return buffer;
    }

    public double nextDouble() {
        return this.delegate.nextDouble();
    }

    public float nextFloat() {
        return this.delegate.nextFloat();
    }

    public double nextGaussian() {
        return this.delegate.nextGaussian();
    }

    public int nextInt() {
        return this.delegate.nextInt();
    }

    public int nextInt(int n) {
        return this.delegate.nextInt(n);
    }

    public long nextLong() {
        return this.delegate.nextLong();
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.delegate.setSeed(seed);
    }

    public long seed() {
        return this.seed;
    }

    public byte nextByte(byte min, byte max) {
        return (byte)this.nextLong(min, max);
    }

    public char nextChar(char min, char max) {
        Ranges.checkRange(Ranges.Type.CHARACTER, Character.valueOf(min), Character.valueOf(max));
        return (char)this.nextLong(min, max);
    }

    public double nextDouble(double min, double max) {
        int comparison = Ranges.checkRange(Ranges.Type.FLOAT, min, max);
        return comparison == 0 ? min : min + (max - min) * this.nextDouble();
    }

    public float nextFloat(float min, float max) {
        int comparison = Ranges.checkRange(Ranges.Type.FLOAT, Float.valueOf(min), Float.valueOf(max));
        return comparison == 0 ? min : min + (max - min) * this.nextFloat();
    }

    public int nextInt(int min, int max) {
        return (int)this.nextLong(min, max);
    }

    public long nextLong(long min, long max) {
        int comparison = Ranges.checkRange(Ranges.Type.INTEGRAL, min, max);
        if (comparison == 0) {
            return min;
        }
        return Ranges.choose(this, min, max);
    }

    public short nextShort(short min, short max) {
        return (short)this.nextLong(min, max);
    }

    public BigInteger nextBigInteger(int numberOfBits) {
        return new BigInteger(numberOfBits, this.delegate);
    }

    public Instant nextInstant(Instant min, Instant max) {
        int comparison = Ranges.checkRange(Ranges.Type.STRING, min, max);
        if (comparison == 0) {
            return min;
        }
        long[] next = this.nextSecondsAndNanos(min.getEpochSecond(), min.getNano(), max.getEpochSecond(), max.getNano());
        return Instant.ofEpochSecond(next[0], next[1]);
    }

    public Duration nextDuration(Duration min, Duration max) {
        int comparison = Ranges.checkRange(Ranges.Type.STRING, min, max);
        if (comparison == 0) {
            return min;
        }
        long[] next = this.nextSecondsAndNanos(min.getSeconds(), min.getNano(), max.getSeconds(), max.getNano());
        return Duration.ofSeconds(next[0], next[1]);
    }

    public <T> T choose(Collection<T> items) {
        return Items.choose(items, this);
    }

    public <T> T choose(T[] items) {
        return items[this.nextInt(items.length)];
    }

    protected final Random delegate() {
        return this.delegate;
    }

    private long[] nextSecondsAndNanos(long minSeconds, long minNanos, long maxSeconds, long maxNanos) {
        BigInteger nanoMin = BigInteger.valueOf(minSeconds).multiply(NANOS_PER_SECOND).add(BigInteger.valueOf(minNanos));
        BigInteger nanoMax = BigInteger.valueOf(maxSeconds).multiply(NANOS_PER_SECOND).add(BigInteger.valueOf(maxNanos));
        BigInteger[] generated = Ranges.choose(this, nanoMin, nanoMax).divideAndRemainder(NANOS_PER_SECOND);
        return new long[]{generated[0].longValue(), generated[1].longValue()};
    }
}

