/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal;

import com.pholser.junit.quickcheck.internal.Weighted;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public final class Items {
    private Items() {
        throw new UnsupportedOperationException();
    }

    public static <T> T choose(Collection<T> items, SourceOfRandomness random) {
        int size = items.size();
        if (size == 0) {
            throw new IllegalArgumentException("Collection is empty, can't pick an element from it");
        }
        if (items instanceof RandomAccess && items instanceof List) {
            List list = (List)items;
            return (T)(size == 1 ? list.get(0) : list.get(random.nextInt(size)));
        }
        if (size == 1) {
            return items.iterator().next();
        }
        Object[] array = items.toArray(new Object[0]);
        return (T)array[random.nextInt(array.length)];
    }

    public static <T> T chooseWeighted(Collection<Weighted<T>> items, SourceOfRandomness random) {
        if (items.size() == 1) {
            return items.iterator().next().item;
        }
        int range = items.stream().mapToInt(i -> i.weight).sum();
        int sample = random.nextInt(range);
        int threshold = 0;
        for (Weighted<T> each : items) {
            if (sample >= (threshold += each.weight)) continue;
            return each.item;
        }
        throw new AssertionError((Object)String.format("sample = %d, range = %d", sample, range));
    }
}

