/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.AggregatedConfiguration;
import com.netflix.config.ConcurrentMapConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentCompositeConfiguration
extends ConcurrentMapConfiguration
implements AggregatedConfiguration,
ConfigurationListener,
Cloneable {
    public static final String ENABLE_STACK_TRACE = "archaius_enable_stack_trace";
    public static final String ENABLE_INSTRUMENTATION = "archaius_enable_instrumentation";
    private final boolean enableStackTrace = Boolean.parseBoolean(System.getProperty("archaius_enable_stack_trace"));
    private final boolean enableInstrumentation = Boolean.parseBoolean(System.getProperty("archaius_enable_instrumentation"));
    private Map<String, AbstractConfiguration> namedConfigurations = new ConcurrentHashMap<String, AbstractConfiguration>();
    private final Map<String, Integer> stackTraces = new ConcurrentHashMap<String, Integer>();
    private final Set<String> usedProperties = ConcurrentHashMap.newKeySet();
    private List<AbstractConfiguration> configList = new CopyOnWriteArrayList<AbstractConfiguration>();
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentCompositeConfiguration.class);
    public static final int EVENT_CONFIGURATION_SOURCE_CHANGED = 10001;
    private volatile boolean propagateEventToParent = true;
    private AbstractConfiguration overrideProperties;
    private AbstractConfiguration containerConfiguration;
    private volatile boolean containerConfigurationChanged = true;
    private ConfigurationListener eventPropagater = new ConfigurationListener(){

        public void configurationChanged(ConfigurationEvent event) {
            boolean beforeUpdate = event.isBeforeUpdate();
            if (ConcurrentCompositeConfiguration.this.propagateEventToParent) {
                int type = event.getType();
                String name = event.getPropertyName();
                Object value = event.getPropertyValue();
                switch (type) {
                    case 4: 
                    case 11: 
                    case 10001: {
                        ConcurrentCompositeConfiguration.this.fireEvent(type, name, value, beforeUpdate);
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (beforeUpdate) {
                            ConcurrentCompositeConfiguration.this.fireEvent(type, name, value, beforeUpdate);
                            break;
                        }
                        AbstractConfiguration sourceConfig = (AbstractConfiguration)event.getSource();
                        AbstractConfiguration winningConf = (AbstractConfiguration)ConcurrentCompositeConfiguration.this.getSource(name);
                        if (winningConf != null && ConcurrentCompositeConfiguration.this.getIndexOfConfiguration(sourceConfig) > ConcurrentCompositeConfiguration.this.getIndexOfConfiguration(winningConf)) break;
                        ConcurrentCompositeConfiguration.this.fireEvent(type, name, value, beforeUpdate);
                        break;
                    }
                    case 2: {
                        Object finalValue = ConcurrentCompositeConfiguration.this.getProperty(name);
                        if (finalValue == null) {
                            ConcurrentCompositeConfiguration.this.fireEvent(type, name, value, beforeUpdate);
                            break;
                        }
                        ConcurrentCompositeConfiguration.this.fireEvent(3, name, finalValue, beforeUpdate);
                        break;
                    }
                }
            }
        }
    };

    public Set<String> getUsedProperties() {
        return this.usedProperties;
    }

    public ConcurrentCompositeConfiguration() {
        this.clear();
    }

    public ConcurrentCompositeConfiguration(AbstractConfiguration containerConfiguration) {
        this.configList.clear();
        this.containerConfiguration = containerConfiguration;
        this.configList.add(containerConfiguration);
    }

    public ConcurrentCompositeConfiguration(AbstractConfiguration containerConfiguration, Collection<? extends AbstractConfiguration> configurations) {
        this(containerConfiguration);
        if (configurations != null) {
            for (AbstractConfiguration abstractConfiguration : configurations) {
                this.addConfiguration(abstractConfiguration);
            }
        }
    }

    public void configurationChanged(ConfigurationEvent event) {
    }

    public void invalidate() {
    }

    @Override
    public final void addConfiguration(AbstractConfiguration config) {
        this.addConfiguration(config, null);
    }

    @Override
    public void addConfiguration(AbstractConfiguration config, String name) {
        if (this.containerConfigurationChanged) {
            this.addConfigurationAtIndex(config, name, this.configList.size());
        } else {
            this.addConfigurationAtIndex(config, name, this.configList.indexOf(this.containerConfiguration));
        }
    }

    @Override
    public List<AbstractConfiguration> getConfigurations() {
        return Collections.unmodifiableList(this.configList);
    }

    @Override
    public List<String> getConfigurationNameList() {
        ArrayList<String> list = new ArrayList<String>(this.configList.size());
        for (AbstractConfiguration configuration : this.configList) {
            boolean foundName = false;
            for (String name : this.namedConfigurations.keySet()) {
                if (configuration != this.namedConfigurations.get(name)) continue;
                foundName = true;
                list.add(name);
                break;
            }
            if (foundName) continue;
            list.add(null);
        }
        return list;
    }

    public int getIndexOfConfiguration(AbstractConfiguration config) {
        return this.configList.indexOf(config);
    }

    public int getIndexOfContainerConfiguration() {
        return this.configList.indexOf(this.containerConfiguration);
    }

    private void checkIndex(int newIndex) {
        if (newIndex < 0 || newIndex > this.configList.size()) {
            throw new IndexOutOfBoundsException(newIndex + " is out of bounds of the size of configuration list " + this.configList.size());
        }
    }

    public void setContainerConfiguration(AbstractConfiguration config, String name, int index) throws IndexOutOfBoundsException {
        if (!this.configList.contains(config)) {
            this.checkIndex(index);
            this.containerConfigurationChanged = true;
            this.containerConfiguration = config;
            this.addConfigurationAtIndex(config, name, index);
        } else {
            logger.warn(config + " is not added as it already exits");
        }
    }

    public void setContainerConfigurationIndex(int newIndex) throws IndexOutOfBoundsException {
        if (newIndex < 0 || newIndex >= this.configList.size()) {
            throw new IndexOutOfBoundsException("Cannot change to the new index " + newIndex + " in the list of size " + this.configList.size());
        }
        if (newIndex == this.configList.indexOf(this.containerConfiguration)) {
            return;
        }
        this.containerConfigurationChanged = true;
        this.configList.remove(this.containerConfiguration);
        this.configList.add(newIndex, this.containerConfiguration);
    }

    public void addConfigurationAtIndex(AbstractConfiguration config, String name, int index) throws IndexOutOfBoundsException {
        if (!this.configList.contains(config)) {
            this.checkIndex(index);
            this.configList.add(index, config);
            if (name != null) {
                this.namedConfigurations.put(name, config);
            }
            config.addConfigurationListener(this.eventPropagater);
            this.fireEvent(10001, null, null, false);
        } else {
            logger.warn(config + " is not added as it already exits");
        }
    }

    public void addConfigurationAtFront(AbstractConfiguration config, String name) {
        this.addConfigurationAtIndex(config, name, 0);
    }

    @Override
    public boolean removeConfiguration(Configuration config) {
        if (!config.equals(this.containerConfiguration)) {
            String configName = this.getNameForConfiguration(config);
            if (configName != null) {
                this.namedConfigurations.remove(configName);
            }
            return this.configList.remove(config);
        }
        throw new IllegalArgumentException("Can't remove container configuration");
    }

    public AbstractConfiguration removeConfigurationAt(int index) {
        AbstractConfiguration config = this.configList.remove(index);
        String nameFound = this.getNameForConfiguration((Configuration)config);
        if (nameFound != null) {
            this.namedConfigurations.remove(nameFound);
        }
        return config;
    }

    @Override
    public Configuration removeConfiguration(String name) {
        Configuration conf = this.getConfiguration(name);
        if (conf != null && !conf.equals(this.containerConfiguration)) {
            this.configList.remove(conf);
            this.namedConfigurations.remove(name);
        } else if (conf != null && conf.equals(this.containerConfiguration)) {
            throw new IllegalArgumentException("Can't remove container configuration");
        }
        return conf;
    }

    @Override
    public int getNumberOfConfigurations() {
        return this.configList.size();
    }

    @Override
    public final void clear() {
        this.fireEvent(4, null, null, true);
        this.configList.clear();
        this.namedConfigurations.clear();
        this.containerConfiguration = new ConcurrentMapConfiguration();
        this.containerConfiguration.setThrowExceptionOnMissing(this.isThrowExceptionOnMissing());
        this.containerConfiguration.setListDelimiter(this.getListDelimiter());
        this.containerConfiguration.setDelimiterParsingDisabled(this.isDelimiterParsingDisabled());
        this.containerConfiguration.addConfigurationListener(this.eventPropagater);
        this.configList.add(this.containerConfiguration);
        this.overrideProperties = new ConcurrentMapConfiguration();
        this.overrideProperties.setThrowExceptionOnMissing(this.isThrowExceptionOnMissing());
        this.overrideProperties.setListDelimiter(this.getListDelimiter());
        this.overrideProperties.setDelimiterParsingDisabled(this.isDelimiterParsingDisabled());
        this.overrideProperties.addConfigurationListener(this.eventPropagater);
        this.fireEvent(4, null, null, false);
        this.containerConfigurationChanged = false;
        this.invalidate();
    }

    public void setOverrideProperty(String key, Object finalValue) {
        this.overrideProperties.setProperty(key, finalValue);
    }

    public void clearOverrideProperty(String key) {
        this.overrideProperties.clearProperty(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.containerConfiguration.setProperty(key, value);
    }

    @Override
    public void addProperty(String key, Object value) {
        this.containerConfiguration.addProperty(key, value);
    }

    public void clearProperty(String key) {
        this.containerConfiguration.clearProperty(key);
    }

    @Override
    public Object getProperty(String key) {
        return this.getProperty(key, true);
    }

    public Object getPropertyUninstrumented(String key) {
        return this.getProperty(key, false);
    }

    private Object getProperty(String key, boolean instrument) {
        if (this.overrideProperties.containsKey(key)) {
            return this.overrideProperties.getProperty(key);
        }
        Configuration firstMatchingConfiguration = null;
        for (Configuration configuration : this.configList) {
            if (!configuration.containsKey(key)) continue;
            if (instrument) {
                this.recordUsage(key);
            }
            firstMatchingConfiguration = configuration;
            break;
        }
        if (firstMatchingConfiguration != null) {
            if (this.enableInstrumentation && !instrument && firstMatchingConfiguration instanceof ConcurrentCompositeConfiguration) {
                return ((ConcurrentCompositeConfiguration)firstMatchingConfiguration).getPropertyUninstrumented(key);
            }
            return firstMatchingConfiguration.getProperty(key);
        }
        return null;
    }

    public void recordUsage(String key) {
        if (this.enableInstrumentation) {
            this.usedProperties.add(key);
            if (this.enableStackTrace) {
                String trace = Arrays.toString(Thread.currentThread().getStackTrace());
                this.stackTraces.merge(trace, 1, (v1, v2) -> v1 + 1);
            }
        }
    }

    @Override
    public Iterator<String> getKeys() throws ConcurrentModificationException {
        LinkedHashSet keys = new LinkedHashSet();
        Iterator it = this.overrideProperties.getKeys();
        while (it.hasNext()) {
            keys.add(it.next());
        }
        for (Configuration configuration : this.configList) {
            Iterator it2 = configuration.getKeys();
            while (it2.hasNext()) {
                try {
                    keys.add(it2.next());
                }
                catch (ConcurrentModificationException e) {
                    logger.error("unexpected exception when iterating the keys for configuration " + configuration + " with name " + this.getNameForConfiguration(configuration));
                    throw e;
                }
            }
        }
        return keys.iterator();
    }

    private String getNameForConfiguration(Configuration config) {
        for (Map.Entry<String, AbstractConfiguration> entry : this.namedConfigurations.entrySet()) {
            if (entry.getValue() != config) continue;
            return entry.getKey();
        }
        return null;
    }

    public Iterator<String> getKeys(String prefix) {
        LinkedHashSet keys = new LinkedHashSet();
        Iterator it = this.overrideProperties.getKeys(prefix);
        while (it.hasNext()) {
            keys.add(it.next());
        }
        for (Configuration configuration : this.configList) {
            Iterator it2 = configuration.getKeys(prefix);
            while (it2.hasNext()) {
                keys.add(it2.next());
            }
        }
        return keys.iterator();
    }

    @Override
    public Set<String> getConfigurationNames() {
        return this.namedConfigurations.keySet();
    }

    @Override
    public boolean isEmpty() {
        if (this.overrideProperties.isEmpty()) {
            return false;
        }
        for (Configuration configuration : this.configList) {
            if (configuration.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(String key) {
        if (this.overrideProperties.containsKey(key)) {
            return true;
        }
        for (Configuration configuration : this.configList) {
            if (!configuration.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public List getList(String key, List defaultValue) {
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator<AbstractConfiguration> it = this.configList.iterator();
        if (this.overrideProperties.containsKey(key)) {
            ConcurrentCompositeConfiguration.appendListProperty(list, (Configuration)this.overrideProperties, key);
        }
        while (it.hasNext() && list.isEmpty()) {
            Configuration config = (Configuration)it.next();
            if (config == this.containerConfiguration && !this.containerConfigurationChanged || !config.containsKey(key)) continue;
            ConcurrentCompositeConfiguration.appendListProperty(list, config, key);
        }
        if (list.isEmpty()) {
            ConcurrentCompositeConfiguration.appendListProperty(list, (Configuration)this.containerConfiguration, key);
        }
        if (list.isEmpty()) {
            return defaultValue;
        }
        ListIterator<Object> lit = list.listIterator();
        while (lit.hasNext()) {
            lit.set(this.interpolate(lit.next()));
        }
        return list;
    }

    public String[] getStringArray(String key) {
        List list = this.getList(key);
        String[] tokens = new String[list.size()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = String.valueOf(list.get(i));
        }
        return tokens;
    }

    @Override
    public Configuration getConfiguration(int index) {
        return (Configuration)this.configList.get(index);
    }

    @Override
    public Configuration getConfiguration(String name) {
        return (Configuration)this.namedConfigurations.get(name);
    }

    public Configuration getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public Object clone() {
        try {
            ConcurrentCompositeConfiguration copy = (ConcurrentCompositeConfiguration)super.clone();
            copy.clearConfigurationListeners();
            copy.configList = new LinkedList<AbstractConfiguration>();
            copy.containerConfiguration = (AbstractConfiguration)ConfigurationUtils.cloneConfiguration((Configuration)this.getContainerConfiguration());
            copy.configList.add(copy.containerConfiguration);
            for (Configuration configuration : this.configList) {
                if (configuration == this.getContainerConfiguration()) continue;
                copy.addConfiguration((AbstractConfiguration)ConfigurationUtils.cloneConfiguration((Configuration)configuration));
            }
            return copy;
        }
        catch (CloneNotSupportedException cnex) {
            throw new ConfigurationRuntimeException((Throwable)cnex);
        }
    }

    public void setDelimiterParsingDisabled(boolean delimiterParsingDisabled) {
        this.containerConfiguration.setDelimiterParsingDisabled(delimiterParsingDisabled);
        super.setDelimiterParsingDisabled(delimiterParsingDisabled);
    }

    public void setListDelimiter(char listDelimiter) {
        this.containerConfiguration.setListDelimiter(listDelimiter);
        super.setListDelimiter(listDelimiter);
    }

    public Configuration getSource(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null!");
        }
        if (this.overrideProperties.containsKey(key)) {
            return this.overrideProperties;
        }
        for (Configuration configuration : this.configList) {
            if (!configuration.containsKey(key)) continue;
            return configuration;
        }
        return null;
    }

    private static void appendListProperty(List<Object> dest, Configuration config, String key) {
        Object value = config.getProperty(key);
        if (value != null) {
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                dest.addAll(col);
            } else {
                dest.add(value);
            }
        }
    }

    public final boolean isPropagateEventFromSubConfigurations() {
        return this.propagateEventToParent;
    }

    public final void setPropagateEventFromSubConfigurations(boolean propagateEventToParent) {
        this.propagateEventToParent = propagateEventToParent;
    }
}

