/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.util;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.ConcurrentMapConfiguration;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.util.InstrumentationAware;
import com.netflix.config.util.OverridingPropertiesConfiguration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationUtils.class);

    public static ConcurrentCompositeConfiguration convertToConcurrentCompositeConfiguration(CombinedConfiguration config) {
        ConcurrentCompositeConfiguration root = new ConcurrentCompositeConfiguration();
        IdentityHashMap<Configuration, String> reverseMap = new IdentityHashMap<Configuration, String>();
        for (String name : config.getConfigurationNames()) {
            Configuration child = config.getConfiguration(name);
            reverseMap.put(child, name);
        }
        for (int i = 0; i < config.getNumberOfConfigurations(); ++i) {
            Configuration child = config.getConfiguration(i);
            String name = (String)reverseMap.get(child);
            if (child instanceof CombinedConfiguration) {
                CombinedConfiguration combinedConf = (CombinedConfiguration)child;
                ConcurrentCompositeConfiguration newConf = ConfigurationUtils.convertToConcurrentCompositeConfiguration(combinedConf);
                root.addConfiguration(newConf, name);
                continue;
            }
            ConcurrentMapConfiguration conf = new ConcurrentMapConfiguration(child);
            root.addConfiguration(conf, name);
        }
        return root;
    }

    public static Map<String, Configuration> getAllNamedConfiguration(Configuration conf) {
        ArrayList<Configuration> toProcess = new ArrayList<Configuration>();
        HashMap<String, Configuration> map = new HashMap<String, Configuration>();
        toProcess.add(conf);
        while (!toProcess.isEmpty()) {
            Configuration current = (Configuration)toProcess.remove(0);
            if (current instanceof ConcurrentCompositeConfiguration) {
                ConcurrentCompositeConfiguration composite = (ConcurrentCompositeConfiguration)current;
                for (String string : composite.getConfigurationNames()) {
                    map.put(string, composite.getConfiguration(string));
                }
                for (Configuration configuration : composite.getConfigurations()) {
                    toProcess.add(configuration);
                }
                continue;
            }
            if (!(current instanceof CombinedConfiguration)) continue;
            CombinedConfiguration combined = (CombinedConfiguration)current;
            for (String string : combined.getConfigurationNames()) {
                map.put(string, combined.getConfiguration(string));
            }
            for (int i = 0; i < combined.getNumberOfConfigurations(); ++i) {
                toProcess.add(combined.getConfiguration(i));
            }
        }
        return map;
    }

    public static Properties getProperties(Configuration config) {
        return ConfigurationUtils.getPropertiesInternal(config, true);
    }

    public static Properties getPropertiesUninstrumented(Configuration config) {
        return ConfigurationUtils.getPropertiesInternal(config, false);
    }

    private static Properties getPropertiesInternal(Configuration config, boolean instrumented) {
        Properties p = new Properties();
        if (config != null) {
            Iterator it = config.getKeys();
            while (it.hasNext()) {
                Object value;
                String key = (String)it.next();
                if (key == null || (value = !instrumented && config instanceof InstrumentationAware ? ((InstrumentationAware)config).getPropertyUninstrumented(key) : config.getProperty(key)) == null) continue;
                p.put(key, value);
            }
        }
        return p;
    }

    public static void loadProperties(Properties props, Configuration config) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            config.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    static void loadFromPropertiesFile(AbstractConfiguration config, String baseUrl, Set<String> loaded, String ... nextLoadKeys) {
        String[] filesToLoad;
        String nextLoad = ConfigurationUtils.getNextLoad((Configuration)config, nextLoadKeys);
        if (nextLoad == null) {
            return;
        }
        for (String fileName : filesToLoad = nextLoad.split(",")) {
            fileName = fileName.trim();
            try {
                URL url = new URL(baseUrl + "/" + fileName);
                if (loaded.contains(url.toExternalForm())) {
                    logger.warn(url + " is already loaded");
                    continue;
                }
                loaded.add(url.toExternalForm());
                OverridingPropertiesConfiguration nextConfig = new OverridingPropertiesConfiguration(url);
                ConfigurationUtils.copyProperties((Configuration)nextConfig, (Configuration)config);
                logger.info("Loaded properties file " + url);
                ConfigurationUtils.loadFromPropertiesFile(config, baseUrl, loaded, nextLoadKeys);
            }
            catch (Throwable e) {
                logger.warn("Unable to load properties file", e);
            }
        }
    }

    public static AbstractConfiguration getConfigFromPropertiesFile(URL startingUrl, Set<String> loaded, String ... nextLoadKeys) throws FileNotFoundException {
        if (loaded.contains(startingUrl.toExternalForm())) {
            logger.warn(startingUrl + " is already loaded");
            return null;
        }
        OverridingPropertiesConfiguration propConfig = null;
        try {
            propConfig = new OverridingPropertiesConfiguration(startingUrl);
            logger.info("Loaded properties file " + startingUrl);
        }
        catch (ConfigurationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FileNotFoundException) {
                throw (FileNotFoundException)cause;
            }
            throw new RuntimeException(e);
        }
        if (nextLoadKeys == null) {
            return propConfig;
        }
        String urlString = startingUrl.toExternalForm();
        String base = urlString.substring(0, urlString.lastIndexOf("/"));
        loaded.add(startingUrl.toString());
        ConfigurationUtils.loadFromPropertiesFile((AbstractConfiguration)propConfig, base, loaded, nextLoadKeys);
        return propConfig;
    }

    public static void copyProperties(Configuration from, Configuration to) {
        Iterator i = from.getKeys();
        while (i.hasNext()) {
            Object value;
            String key = (String)i.next();
            if (key == null || (value = from.getProperty(key)) == null) continue;
            to.setProperty(key, value);
        }
    }

    public static Properties getPropertiesFromFile(URL startingUrl, Set<String> loaded, String ... nextLoadKeys) throws FileNotFoundException {
        AbstractConfiguration config = ConfigurationUtils.getConfigFromPropertiesFile(startingUrl, loaded, nextLoadKeys);
        return ConfigurationUtils.getProperties((Configuration)config);
    }

    private static String getNextLoad(Configuration propConfig, String ... nextLoadPropertyKeys) {
        String nextLoadKeyToUse = null;
        for (String key : nextLoadPropertyKeys) {
            if (propConfig.getProperty(key) == null) continue;
            nextLoadKeyToUse = key;
            break;
        }
        if (nextLoadKeyToUse == null) {
            return null;
        }
        ConcurrentMapConfiguration config = new ConcurrentMapConfiguration();
        ConfigurationUtils.copyProperties((Configuration)ConfigurationManager.getConfigInstance(), (Configuration)config);
        ConfigurationUtils.copyProperties(propConfig, (Configuration)config);
        List list = config.getList(nextLoadKeyToUse);
        StringBuilder sb = new StringBuilder();
        for (Object value : list) {
            sb.append(value).append(",");
        }
        String nextLoad = sb.toString();
        propConfig.clearProperty(nextLoadKeyToUse);
        return nextLoad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesFromInputStream(InputStream fin) throws IOException {
        Properties props = new Properties();
        InputStreamReader reader = new InputStreamReader(fin, "UTF-8");
        try {
            props.load(reader);
            Properties properties = props;
            return properties;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (fin != null) {
                fin.close();
            }
        }
    }
}

