/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.DynamicFloatProperty;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicLongProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.config.Property;
import com.netflix.config.PropertyWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedDynamicProperty {
    private static final Logger logger = LoggerFactory.getLogger(ChainedDynamicProperty.class);

    public static class DynamicBooleanPropertyThatSupportsNull
    extends PropertyWrapper<Boolean> {
        public DynamicBooleanPropertyThatSupportsNull(String propName, Boolean defaultValue) {
            super(propName, defaultValue);
        }

        public Boolean get() {
            return this.prop.getBoolean((Boolean)this.defaultValue);
        }

        @Override
        public Boolean getValue() {
            return this.get();
        }
    }

    public static class BooleanProperty
    extends ChainLink<Boolean> {
        private final DynamicBooleanPropertyThatSupportsNull sProp;
        private Runnable callback;

        public BooleanProperty(DynamicBooleanPropertyThatSupportsNull sProperty) {
            super(sProperty.getDefaultValue());
            this.sProp = sProperty;
        }

        public BooleanProperty(String name, DynamicBooleanPropertyThatSupportsNull sProperty) {
            this(name, new BooleanProperty(sProperty));
        }

        public BooleanProperty(String name, BooleanProperty next) {
            super(next);
            this.sProp = new DynamicBooleanPropertyThatSupportsNull(name, null);
            this.callback = new Runnable(){

                @Override
                public void run() {
                    logger.info("Property changed: '" + this.getName() + " = " + this.getValue() + "'");
                    this.checkAndFlip();
                }
            };
            this.sProp.addCallback(this.callback);
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return this.sProp.getValue() != null;
        }

        @Override
        protected Property<Boolean> getReferencedProperty() {
            return this.sProp;
        }

        @Override
        public void removeAllCallbacks() {
            super.removeAllCallbacks();
            this.sProp.prop.removeCallback(this.callback);
        }
    }

    public static class FloatProperty
    extends ChainLink<Float> {
        private final DynamicFloatProperty sProp;
        private Runnable callback;

        public FloatProperty(DynamicFloatProperty sProperty) {
            super(sProperty.getDefaultValue());
            this.sProp = sProperty;
        }

        public FloatProperty(String name, DynamicFloatProperty sProperty) {
            this(name, new FloatProperty(sProperty));
        }

        public FloatProperty(String name, FloatProperty next) {
            super(next);
            this.sProp = DynamicPropertyFactory.getInstance().getFloatProperty(name, Float.MIN_VALUE);
            this.callback = new Runnable(){

                @Override
                public void run() {
                    logger.info("Property changed: '" + this.getName() + " = " + this.getValue() + "'");
                    this.checkAndFlip();
                }
            };
            this.sProp.addCallback(this.callback);
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return Math.abs(this.sProp.get() - Float.MIN_VALUE) > 1.0E-6f;
        }

        @Override
        protected Property<Float> getReferencedProperty() {
            return this.sProp;
        }

        @Override
        public void removeAllCallbacks() {
            super.removeAllCallbacks();
            this.sProp.prop.removeCallback(this.callback);
        }
    }

    public static class LongProperty
    extends ChainLink<Long> {
        private final DynamicLongProperty sProp;
        private Runnable callback;

        public LongProperty(DynamicLongProperty sProperty) {
            super(sProperty.getDefaultValue());
            this.sProp = sProperty;
        }

        public LongProperty(String name, DynamicLongProperty sProperty) {
            this(name, new LongProperty(sProperty));
        }

        public LongProperty(String name, LongProperty next) {
            super(next);
            this.sProp = DynamicPropertyFactory.getInstance().getLongProperty(name, Long.MIN_VALUE);
            this.callback = new Runnable(){

                @Override
                public void run() {
                    logger.info("Property changed: '" + this.getName() + " = " + this.getValue() + "'");
                    this.checkAndFlip();
                }
            };
            this.sProp.addCallback(this.callback);
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return this.sProp.get() != Long.MIN_VALUE;
        }

        @Override
        protected Property<Long> getReferencedProperty() {
            return this.sProp;
        }

        @Override
        public void removeAllCallbacks() {
            super.removeAllCallbacks();
            this.sProp.prop.removeCallback(this.callback);
        }
    }

    public static class IntProperty
    extends ChainLink<Integer> {
        private final DynamicIntProperty sProp;
        private Runnable callback;

        public IntProperty(DynamicIntProperty sProperty) {
            super(sProperty.getDefaultValue());
            this.sProp = sProperty;
        }

        public IntProperty(String name, DynamicIntProperty sProperty) {
            this(name, new IntProperty(sProperty));
        }

        public IntProperty(String name, IntProperty next) {
            super(next);
            this.sProp = DynamicPropertyFactory.getInstance().getIntProperty(name, Integer.MIN_VALUE);
            this.callback = new Runnable(){

                @Override
                public void run() {
                    logger.info("Property changed: '" + this.getName() + " = " + this.getValue() + "'");
                    this.checkAndFlip();
                }
            };
            this.sProp.addCallback(this.callback);
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return this.sProp.get() != Integer.MIN_VALUE;
        }

        @Override
        protected Property<Integer> getReferencedProperty() {
            return this.sProp;
        }

        @Override
        public void removeAllCallbacks() {
            super.removeAllCallbacks();
            this.sProp.prop.removeCallback(this.callback);
        }
    }

    public static class StringProperty
    extends ChainLink<String> {
        private final DynamicStringProperty sProp;
        private Runnable callback;

        public StringProperty(DynamicStringProperty sProperty) {
            super(sProperty.getDefaultValue());
            this.sProp = sProperty;
        }

        public StringProperty(String name, DynamicStringProperty sProperty) {
            this(name, new StringProperty(sProperty));
        }

        public StringProperty(String name, StringProperty next) {
            super(next);
            this.sProp = DynamicPropertyFactory.getInstance().getStringProperty(name, null);
            this.callback = new Runnable(){

                @Override
                public void run() {
                    logger.info("Property changed: '" + this.getName() + " = " + (String)this.getValue() + "'");
                    this.checkAndFlip();
                }
            };
            this.sProp.addCallback(this.callback);
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return this.sProp.get() != null;
        }

        @Override
        protected Property<String> getReferencedProperty() {
            return this.sProp;
        }

        @Override
        public void removeAllCallbacks() {
            super.removeAllCallbacks();
            this.sProp.prop.removeCallback(this.callback);
        }
    }

    public static abstract class ChainLink<T>
    implements Property<T> {
        private final AtomicReference<ChainLink<T>> pReference;
        private final ChainLink<T> next;
        private final List<Runnable> callbacks;
        private final T defaultValue;

        public abstract boolean isValueAcceptable();

        protected abstract Property<T> getReferencedProperty();

        public ChainLink(T defaultValue) {
            this.next = null;
            this.pReference = new AtomicReference<ChainLink>(this);
            this.callbacks = new ArrayList<Runnable>();
            this.defaultValue = defaultValue;
        }

        public ChainLink(ChainLink<T> nextProperty) {
            this.next = nextProperty;
            this.pReference = new AtomicReference<ChainLink<T>>(this.next);
            this.callbacks = new ArrayList<Runnable>();
            this.defaultValue = nextProperty.getDefaultValue();
        }

        protected void checkAndFlip() {
            if (this.next == null) {
                this.pReference.set(this);
                return;
            }
            if (this.isValueAcceptable()) {
                logger.info("Flipping property: " + this.getName() + " to use it's current value:" + this.getValue());
                this.pReference.set(this);
            } else {
                logger.info("Flipping property: " + this.getName() + " to use NEXT property: " + this.next);
                this.pReference.set(this.next);
            }
            for (Runnable r : this.callbacks) {
                r.run();
            }
        }

        public T get() {
            if (this.pReference.get() == this) {
                return this.getValue();
            }
            return this.pReference.get().get();
        }

        @Override
        public T getValue() {
            return this.getReferencedProperty().getValue();
        }

        @Override
        public T getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public String getName() {
            return this.getReferencedProperty().getName();
        }

        @Override
        public long getChangedTimestamp() {
            if (this.pReference.get() == this) {
                return this.getReferencedProperty().getChangedTimestamp();
            }
            return this.pReference.get().getChangedTimestamp();
        }

        @Override
        public void addCallback(Runnable r) {
            this.callbacks.add(r);
        }

        @Override
        public void removeAllCallbacks() {
            this.callbacks.clear();
        }

        public String toString() {
            return this.getName() + " = " + this.get();
        }
    }
}

