/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.Rate;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.AbstractCacheRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.RateLimiterErrorHandler;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

public class RedisRateLimiter
extends AbstractCacheRateLimiter {
    private final RateLimiterErrorHandler rateLimiterErrorHandler;
    private final StringRedisTemplate redisTemplate;
    private final RedisScript<Long> redisScript;

    public RedisRateLimiter(RateLimiterErrorHandler rateLimiterErrorHandler, StringRedisTemplate redisTemplate) {
        this.rateLimiterErrorHandler = rateLimiterErrorHandler;
        this.redisTemplate = redisTemplate;
        this.redisScript = this.getScript();
    }

    @Override
    protected void calcRemainingLimit(Long limit, Duration refreshInterval, Long requestTime, String key, Rate rate) {
        if (Objects.nonNull(limit)) {
            long usage = requestTime == null ? 1L : 0L;
            Long remaining = this.calcRemaining(limit, refreshInterval, usage, key, rate);
            rate.setRemaining(remaining);
        }
    }

    @Override
    protected void calcRemainingQuota(Long quota, Duration refreshInterval, Long requestTime, String key, Rate rate) {
        if (Objects.nonNull(quota)) {
            String quotaKey = key + "-quota";
            long usage = requestTime != null ? requestTime : 0L;
            Long remaining = this.calcRemaining(quota, refreshInterval, usage, quotaKey, rate);
            rate.setRemainingQuota(remaining);
        }
    }

    private Long calcRemaining(Long limit, Duration refreshInterval, long usage, String key, Rate rate) {
        rate.setReset(refreshInterval.toMillis());
        Long current = 0L;
        try {
            current = (Long)this.redisTemplate.execute(this.redisScript, Collections.singletonList(key), new Object[]{Long.toString(usage), Long.toString(refreshInterval.getSeconds())});
        }
        catch (RuntimeException e) {
            String msg = "Failed retrieving rate for " + key + ", will return the current value";
            this.rateLimiterErrorHandler.handleError(msg, e);
        }
        return Math.max(-1L, limit - (long)(current != null ? current.intValue() : 0));
    }

    private RedisScript<Long> getScript() {
        DefaultRedisScript redisScript = new DefaultRedisScript();
        redisScript.setLocation((Resource)new ClassPathResource("/scripts/ratelimit.lua"));
        redisScript.setResultType(Long.class);
        return redisScript;
    }
}

