/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.bucket4j;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.Rate;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.AbstractCacheRateLimiter;
import io.github.bucket4j.AbstractBucketBuilder;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.Bucket4j;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.Extension;
import io.github.bucket4j.grid.ProxyManager;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

abstract class AbstractBucket4jRateLimiter<T extends AbstractBucketBuilder<T>, E extends Extension<T>>
extends AbstractCacheRateLimiter {
    private final Class<E> extension;
    private ProxyManager<String> buckets;

    AbstractBucket4jRateLimiter(Class<E> extension) {
        this.extension = extension;
    }

    void init() {
        this.buckets = this.getProxyManager(this.getExtension());
    }

    private E getExtension() {
        return (E)Bucket4j.extension(this.extension);
    }

    protected abstract ProxyManager<String> getProxyManager(E var1);

    private Bucket getQuotaBucket(String key, Long quota, Duration refreshInterval) {
        return this.buckets.getProxy((Serializable)((Object)(key + "-quota")), this.getBucketConfiguration(quota, refreshInterval));
    }

    private Bucket getLimitBucket(String key, Long limit, Duration refreshInterval) {
        return this.buckets.getProxy((Serializable)((Object)key), this.getBucketConfiguration(limit, refreshInterval));
    }

    private Supplier<BucketConfiguration> getBucketConfiguration(Long capacity, Duration period) {
        return () -> Bucket4j.configurationBuilder().addLimit(Bandwidth.simple((long)capacity, (Duration)period)).build();
    }

    private void setRemaining(Rate rate, long remaining, boolean isQuota) {
        if (isQuota) {
            rate.setRemainingQuota(remaining);
        } else {
            rate.setRemaining(remaining);
        }
    }

    private void calcAndSetRemainingBucket(Long consume, Rate rate, Bucket bucket, boolean isQuota) {
        ConsumptionProbe consumptionProbe = bucket.tryConsumeAndReturnRemaining(consume.longValue());
        long nanosToWaitForRefill = consumptionProbe.getNanosToWaitForRefill();
        rate.setReset(TimeUnit.NANOSECONDS.toMillis(nanosToWaitForRefill));
        if (consumptionProbe.isConsumed()) {
            long remainingTokens = consumptionProbe.getRemainingTokens();
            this.setRemaining(rate, remainingTokens, isQuota);
        } else {
            this.setRemaining(rate, -1L, isQuota);
            bucket.tryConsumeAsMuchAsPossible(consume.longValue());
        }
    }

    private void calcAndSetRemainingBucket(Bucket bucket, Rate rate, boolean isQuota) {
        long availableTokens = bucket.getAvailableTokens();
        long remaining = availableTokens > 0L ? availableTokens : -1L;
        this.setRemaining(rate, remaining, isQuota);
    }

    @Override
    protected void calcRemainingLimit(Long limit, Duration refreshInterval, Long requestTime, String key, Rate rate) {
        if (limit == null) {
            return;
        }
        Bucket bucket = this.getLimitBucket(key, limit, refreshInterval);
        if (requestTime == null) {
            this.calcAndSetRemainingBucket(1L, rate, bucket, false);
        } else {
            this.calcAndSetRemainingBucket(bucket, rate, false);
        }
    }

    @Override
    protected void calcRemainingQuota(Long quota, Duration refreshInterval, Long requestTime, String key, Rate rate) {
        if (quota == null) {
            return;
        }
        Bucket bucket = this.getQuotaBucket(key, quota, refreshInterval);
        if (requestTime != null) {
            this.calcAndSetRemainingBucket(requestTime, rate, bucket, true);
        } else {
            this.calcAndSetRemainingBucket(bucket, rate, true);
        }
    }
}

