/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters;

import com.google.common.collect.Maps;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.Rate;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitKeyGenerator;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitUtils;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.ResponseHeadersVerbosity;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters.AbstractRateLimitFilter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.support.RateLimitExceededEvent;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.support.RateLimitExceededException;
import com.netflix.zuul.context.RequestContext;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.web.util.UrlPathHelper;

public class RateLimitPreFilter
extends AbstractRateLimitFilter {
    private final RateLimiter rateLimiter;
    private final RateLimitKeyGenerator rateLimitKeyGenerator;
    private final ApplicationEventPublisher eventPublisher;

    public RateLimitPreFilter(RateLimitProperties properties, RouteLocator routeLocator, UrlPathHelper urlPathHelper, RateLimiter rateLimiter, RateLimitKeyGenerator rateLimitKeyGenerator, RateLimitUtils rateLimitUtils, ApplicationEventPublisher eventPublisher) {
        super(properties, routeLocator, urlPathHelper, rateLimitUtils);
        this.rateLimiter = rateLimiter;
        this.rateLimitKeyGenerator = rateLimitKeyGenerator;
        this.eventPublisher = eventPublisher;
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return this.properties.getPreFilterOrder();
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletResponse response = ctx.getResponse();
        HttpServletRequest request = ctx.getRequest();
        Route route = this.route(request);
        this.policy(route, request).forEach(policy -> {
            HashMap responseHeaders = Maps.newHashMap();
            String key = this.rateLimitKeyGenerator.key(request, route, (RateLimitProperties.Policy)policy);
            Rate rate = this.rateLimiter.consume((RateLimitProperties.Policy)policy, key, null);
            Long limit = policy.getLimit();
            Long remaining = rate.getRemaining();
            if (limit != null) {
                responseHeaders.put("X-RateLimit-Limit", String.valueOf(limit));
                responseHeaders.put("X-RateLimit-Remaining", String.valueOf(Math.max(remaining, 0L)));
            }
            Duration quota = policy.getQuota();
            Long remainingQuota = rate.getRemainingQuota();
            if (quota != null) {
                request.setAttribute("rateLimitRequestStartTime", (Object)System.currentTimeMillis());
                responseHeaders.put("X-RateLimit-Quota", String.valueOf(quota.getSeconds()));
                responseHeaders.put("X-RateLimit-Remaining-Quota", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(Math.max(remainingQuota, 0L))));
            }
            responseHeaders.put("X-RateLimit-Reset", String.valueOf(rate.getReset()));
            if (this.properties.isAddResponseHeaders()) {
                String httpHeaderKey = key.replaceAll("[^A-Za-z0-9-.]", "_").replaceAll("__", "_");
                for (Map.Entry headersEntry : responseHeaders.entrySet()) {
                    String header = ResponseHeadersVerbosity.VERBOSE.equals((Object)this.properties.getResponseHeaders()) ? (String)headersEntry.getKey() + "-" + httpHeaderKey : (String)headersEntry.getKey();
                    response.setHeader(header, (String)headersEntry.getValue());
                }
            }
            if (limit != null && remaining < 0L || quota != null && remainingQuota < 0L) {
                ctx.setResponseStatusCode(HttpStatus.TOO_MANY_REQUESTS.value());
                ctx.put((Object)"rateLimitExceeded", (Object)"true");
                ctx.setSendZuulResponse(false);
                this.eventPublisher.publishEvent((ApplicationEvent)new RateLimitExceededEvent(this, (RateLimitProperties.Policy)policy, this.rateLimitUtils.getRemoteAddress(request)));
                throw new RateLimitExceededException();
            }
        });
        return null;
    }
}

