/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitUtils;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.web.util.UrlPathHelper;

abstract class AbstractRateLimitFilter
extends ZuulFilter {
    protected final RateLimitProperties properties;
    protected final RateLimitUtils rateLimitUtils;
    private final RouteLocator routeLocator;
    private final UrlPathHelper urlPathHelper;

    AbstractRateLimitFilter(RateLimitProperties properties, RouteLocator routeLocator, UrlPathHelper urlPathHelper, RateLimitUtils rateLimitUtils) {
        this.properties = properties;
        this.routeLocator = routeLocator;
        this.urlPathHelper = urlPathHelper;
        this.rateLimitUtils = rateLimitUtils;
    }

    public boolean shouldFilter() {
        HttpServletRequest request = RequestContext.getCurrentContext().getRequest();
        return this.properties.isEnabled() && !this.policy(this.route(request), request).isEmpty();
    }

    Route route(HttpServletRequest request) {
        Route route = (Route)RequestContext.getCurrentContext().get((Object)"rateLimitRequestRoute");
        if (route != null) {
            return route;
        }
        String requestURI = this.urlPathHelper.getPathWithinApplication(request);
        route = this.routeLocator.getMatchingRoute(requestURI);
        this.addObjectToCurrentRequestContext("rateLimitRequestRoute", route);
        return route;
    }

    protected List<RateLimitProperties.Policy> policy(Route route, HttpServletRequest request) {
        List<RateLimitProperties.Policy> policies = (List<RateLimitProperties.Policy>)RequestContext.getCurrentContext().get((Object)"rateLimitRequestPolicy");
        if (policies != null) {
            return policies;
        }
        String routeId = route != null ? route.getId() : null;
        RequestContext.getCurrentContext().put((Object)"rateLimitAlreadyDone", (Object)false);
        policies = this.properties.getPolicies(routeId).stream().filter(policy -> this.applyPolicy(request, route, (RateLimitProperties.Policy)policy)).collect(Collectors.toList());
        this.addObjectToCurrentRequestContext("rateLimitRequestPolicy", policies);
        return policies;
    }

    private void addObjectToCurrentRequestContext(String key, Object object) {
        if (object != null) {
            RequestContext.getCurrentContext().put((Object)key, object);
        }
    }

    private boolean applyPolicy(HttpServletRequest request, Route route, RateLimitProperties.Policy policy) {
        List<RateLimitProperties.Policy.MatchType> types = policy.getType();
        boolean isAlreadyLimited = (Boolean)RequestContext.getCurrentContext().get((Object)"rateLimitAlreadyDone");
        if (policy.isBreakOnMatch() && !isAlreadyLimited && types.stream().allMatch(type -> type.apply(request, route, this.rateLimitUtils))) {
            RequestContext.getCurrentContext().put((Object)"rateLimitAlreadyDone", (Object)true);
        }
        return (types.isEmpty() || types.stream().allMatch(type -> type.apply(request, route, this.rateLimitUtils))) && !isAlreadyLimited;
    }
}

