/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.Rate;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.AbstractCacheRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.RateLimiterErrorHandler;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisRateLimiter
extends AbstractCacheRateLimiter {
    private final RateLimiterErrorHandler rateLimiterErrorHandler;
    private final StringRedisTemplate redisTemplate;

    public RedisRateLimiter(RateLimiterErrorHandler rateLimiterErrorHandler, StringRedisTemplate redisTemplate) {
        this.rateLimiterErrorHandler = rateLimiterErrorHandler;
        this.redisTemplate = redisTemplate;
    }

    @Override
    protected void calcRemainingLimit(Long limit, Duration refreshInterval, Long requestTime, String key, Rate rate) {
        if (Objects.nonNull(limit)) {
            long usage = requestTime == null ? 1L : 0L;
            Long remaining = this.calcRemaining(limit, refreshInterval, usage, key, rate);
            rate.setRemaining(remaining);
        }
    }

    @Override
    protected void calcRemainingQuota(Long quota, Duration refreshInterval, Long requestTime, String key, Rate rate) {
        if (Objects.nonNull(quota)) {
            String quotaKey = key + "-quota";
            long usage = requestTime != null ? requestTime : 0L;
            Long remaining = this.calcRemaining(quota, refreshInterval, usage, quotaKey, rate);
            rate.setRemainingQuota(remaining);
        }
    }

    private Long calcRemaining(Long limit, Duration refreshInterval, long usage, String key, Rate rate) {
        rate.setReset(refreshInterval.toMillis());
        Long current = 0L;
        try {
            Boolean present = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)Long.toString(usage), refreshInterval.getSeconds(), TimeUnit.SECONDS);
            current = Boolean.FALSE.equals(present) ? this.redisTemplate.opsForValue().increment((Object)key, usage) : Long.valueOf(usage);
        }
        catch (RuntimeException e) {
            String msg = "Failed retrieving rate for " + key + ", will return the current value";
            this.rateLimiterErrorHandler.handleError(msg, e);
        }
        return Math.max(-1L, limit - (current != null ? current : 0L));
    }
}

