/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit;

import com.ecwid.consul.v1.ConsulClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.core.IMap;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitKeyGenerator;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitUtils;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.ConsulRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.DefaultRateLimiterErrorHandler;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.RateLimiterErrorHandler;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.RedisRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.bucket4j.Bucket4jHazelcastRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.bucket4j.Bucket4jIgniteRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.bucket4j.Bucket4jInfinispanRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.bucket4j.Bucket4jJCacheRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.springdata.JpaRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.springdata.RateLimiterRepository;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters.RateLimitPostFilter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters.RateLimitPreFilter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.support.DefaultRateLimitKeyGenerator;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.support.DefaultRateLimitUtils;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.support.SecuredRateLimitUtils;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.support.StringToMatchTypeConverter;
import com.netflix.zuul.ZuulFilter;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.hazelcast.Hazelcast;
import io.github.bucket4j.grid.ignite.Ignite;
import io.github.bucket4j.grid.infinispan.Infinispan;
import io.github.bucket4j.grid.jcache.JCache;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.infinispan.functional.FunctionalMap;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.consul.ConditionalOnConsulEnabled;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.util.UrlPathHelper;

@Configuration
@EnableConfigurationProperties(value={RateLimitProperties.class})
@ConditionalOnProperty(prefix="zuul.ratelimit", name={"enabled"}, havingValue="true")
public class RateLimitAutoConfiguration {
    private static final UrlPathHelper URL_PATH_HELPER = new UrlPathHelper();

    @Bean
    @ConfigurationPropertiesBinding
    public StringToMatchTypeConverter stringToMatchTypeConverter() {
        return new StringToMatchTypeConverter();
    }

    @Bean
    @ConditionalOnMissingBean(value={RateLimiterErrorHandler.class})
    public RateLimiterErrorHandler rateLimiterErrorHandler() {
        return new DefaultRateLimiterErrorHandler();
    }

    @Bean
    public ZuulFilter rateLimiterPreFilter(RateLimiter rateLimiter, RateLimitProperties rateLimitProperties, RouteLocator routeLocator, RateLimitKeyGenerator rateLimitKeyGenerator, RateLimitUtils rateLimitUtils, ApplicationEventPublisher eventPublisher) {
        return new RateLimitPreFilter(rateLimitProperties, routeLocator, URL_PATH_HELPER, rateLimiter, rateLimitKeyGenerator, rateLimitUtils, eventPublisher);
    }

    @Bean
    public ZuulFilter rateLimiterPostFilter(RateLimiter rateLimiter, RateLimitProperties rateLimitProperties, RouteLocator routeLocator, RateLimitKeyGenerator rateLimitKeyGenerator, RateLimitUtils rateLimitUtils) {
        return new RateLimitPostFilter(rateLimitProperties, routeLocator, URL_PATH_HELPER, rateLimiter, rateLimitKeyGenerator, rateLimitUtils);
    }

    @Bean
    @ConditionalOnMissingBean(value={RateLimitKeyGenerator.class})
    public RateLimitKeyGenerator ratelimitKeyGenerator(RateLimitProperties properties, RateLimitUtils rateLimitUtils) {
        return new DefaultRateLimitKeyGenerator(properties, rateLimitUtils);
    }

    @EntityScan
    @Configuration
    @EnableJpaRepositories(basePackages={"com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.springdata"})
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="JPA")
    public static class SpringDataConfiguration {
        @Bean
        public RateLimiter springDataRateLimiter(RateLimiterErrorHandler rateLimiterErrorHandler, RateLimiterRepository rateLimiterRepository) {
            return new JpaRateLimiter(rateLimiterErrorHandler, rateLimiterRepository);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnClass(value={Infinispan.class, FunctionalMap.ReadWriteMap.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="BUCKET4J_INFINISPAN")
    public static class Bucket4jInfinispanConfiguration {
        @Bean
        public RateLimiter bucket4jInfinispanRateLimiter(@Qualifier(value="RateLimit") FunctionalMap.ReadWriteMap<String, GridBucketState> readWriteMap) {
            return new Bucket4jInfinispanRateLimiter(readWriteMap);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnClass(value={Ignite.class, IgniteCache.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="BUCKET4J_IGNITE")
    public static class Bucket4jIgniteConfiguration {
        @Bean
        public RateLimiter bucket4jIgniteRateLimiter(@Qualifier(value="RateLimit") IgniteCache<String, GridBucketState> cache) {
            return new Bucket4jIgniteRateLimiter(cache);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnClass(value={Hazelcast.class, IMap.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="BUCKET4J_HAZELCAST")
    public static class Bucket4jHazelcastConfiguration {
        @Bean
        public RateLimiter bucket4jHazelcastRateLimiter(@Qualifier(value="RateLimit") IMap<String, GridBucketState> rateLimit) {
            return new Bucket4jHazelcastRateLimiter(rateLimit);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnClass(value={JCache.class, Cache.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="BUCKET4J_JCACHE")
    public static class Bucket4jJCacheConfiguration {
        @Bean
        public RateLimiter jCache4jHazelcastRateLimiter(@Qualifier(value="RateLimit") Cache<String, GridBucketState> cache) {
            return new Bucket4jJCacheRateLimiter(cache);
        }
    }

    @Configuration
    @ConditionalOnConsulEnabled
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="CONSUL")
    public static class ConsulConfiguration {
        @Bean
        public RateLimiter consultRateLimiter(RateLimiterErrorHandler rateLimiterErrorHandler, ConsulClient consulClient, ObjectMapper objectMapper) {
            return new ConsulRateLimiter(rateLimiterErrorHandler, consulClient, objectMapper);
        }
    }

    @Configuration
    @ConditionalOnClass(value={StringRedisTemplate.class})
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="REDIS")
    public static class RedisConfiguration {
        private static final String REDIS_TEMPLATE_BEAN_NAME = "rateLimiterRedisTemplate";

        @Bean(value={"rateLimiterRedisTemplate"})
        public StringRedisTemplate redisTemplate(RedisConnectionFactory connectionFactory) {
            return new StringRedisTemplate(connectionFactory);
        }

        @Bean
        public RateLimiter redisRateLimiter(RateLimiterErrorHandler rateLimiterErrorHandler, @Qualifier(value="rateLimiterRedisTemplate") StringRedisTemplate redisTemplate) {
            return new RedisRateLimiter(rateLimiterErrorHandler, redisTemplate);
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={RateLimitUtils.class})
    public static class RateLimitUtilsConfiguration {
        @Bean
        @ConditionalOnClass(name={"org.springframework.security.core.Authentication"})
        public RateLimitUtils securedRateLimitUtils(RateLimitProperties rateLimitProperties) {
            return new SecuredRateLimitUtils(rateLimitProperties);
        }

        @Bean
        @ConditionalOnMissingClass(value={"org.springframework.security.core.Authentication"})
        public RateLimitUtils rateLimitUtils(RateLimitProperties rateLimitProperties) {
            return new DefaultRateLimitUtils(rateLimitProperties);
        }
    }
}

