/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.Rate;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.RateLimiterErrorHandler;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public abstract class AbstractRateLimiter
implements RateLimiter {
    private final RateLimiterErrorHandler rateLimiterErrorHandler;

    protected AbstractRateLimiter(RateLimiterErrorHandler rateLimiterErrorHandler) {
        this.rateLimiterErrorHandler = rateLimiterErrorHandler;
    }

    protected abstract Rate getRate(String var1);

    protected abstract void saveRate(Rate var1);

    @Override
    public synchronized Rate consume(RateLimitProperties.Policy policy, String key, Long requestTime) {
        Rate rate = this.create(policy, key);
        this.updateRate(policy, rate, requestTime);
        try {
            this.saveRate(rate);
        }
        catch (RuntimeException e) {
            this.rateLimiterErrorHandler.handleSaveError(key, e);
        }
        return rate;
    }

    private Rate create(RateLimitProperties.Policy policy, String key) {
        Rate rate = null;
        try {
            rate = this.getRate(key);
        }
        catch (RuntimeException e) {
            this.rateLimiterErrorHandler.handleFetchError(key, e);
        }
        if (!this.isExpired(rate)) {
            return rate;
        }
        Long limit = policy.getLimit();
        Long quota = policy.getQuota() != null ? Long.valueOf(TimeUnit.SECONDS.toMillis(policy.getQuota())) : null;
        Long refreshInterval = TimeUnit.SECONDS.toMillis(policy.getRefreshInterval());
        Date expiration = new Date(System.currentTimeMillis() + refreshInterval);
        return new Rate(key, limit, quota, refreshInterval, expiration);
    }

    private void updateRate(RateLimitProperties.Policy policy, Rate rate, Long requestTime) {
        if (rate.getReset() > 0L) {
            Long reset = rate.getExpiration().getTime() - System.currentTimeMillis();
            rate.setReset(reset);
        }
        if (policy.getLimit() != null && requestTime == null) {
            rate.setRemaining(Math.max(-1L, rate.getRemaining() - 1L));
        }
        if (policy.getQuota() != null && requestTime != null) {
            rate.setRemainingQuota(Math.max(-1L, rate.getRemainingQuota() - requestTime));
        }
    }

    private boolean isExpired(Rate rate) {
        return rate == null || rate.getExpiration().getTime() < System.currentTimeMillis();
    }
}

