/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitUtils;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitRepository;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitType;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.validators.Policies;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.validation.annotation.Validated;

@Validated
@RefreshScope
@ConfigurationProperties(value="zuul.ratelimit")
public class RateLimitProperties {
    public static final String PREFIX = "zuul.ratelimit";
    @Valid
    @NotNull
    @Policies
    @NestedConfigurationProperty
    private List<Policy> defaultPolicyList = Lists.newArrayList();
    @Valid
    @NotNull
    @Policies
    @NestedConfigurationProperty
    private Map<String, List<Policy>> policyList = Maps.newHashMap();
    private boolean behindProxy;
    private boolean enabled;
    private boolean addResponseHeaders = true;
    @NotNull
    @Value(value="${spring.application.name:rate-limit-application}")
    private String keyPrefix;
    @NotNull
    private RateLimitRepository repository;
    private int postFilterOrder = 990;
    private int preFilterOrder = -1;

    public List<Policy> getPolicies(String key) {
        return this.policyList.getOrDefault(key, this.defaultPolicyList);
    }

    public List<Policy> getDefaultPolicyList() {
        return this.defaultPolicyList;
    }

    public void setDefaultPolicyList(List<Policy> defaultPolicyList) {
        this.defaultPolicyList = defaultPolicyList;
    }

    public Map<String, List<Policy>> getPolicyList() {
        return this.policyList;
    }

    public void setPolicyList(Map<String, List<Policy>> policyList) {
        this.policyList = policyList;
    }

    public boolean isBehindProxy() {
        return this.behindProxy;
    }

    public void setBehindProxy(boolean behindProxy) {
        this.behindProxy = behindProxy;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isAddResponseHeaders() {
        return this.addResponseHeaders;
    }

    public void setAddResponseHeaders(boolean addResponseHeaders) {
        this.addResponseHeaders = addResponseHeaders;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public RateLimitRepository getRepository() {
        return this.repository;
    }

    public void setRepository(RateLimitRepository repository) {
        this.repository = repository;
    }

    public int getPostFilterOrder() {
        return this.postFilterOrder;
    }

    public void setPostFilterOrder(int postFilterOrder) {
        this.postFilterOrder = postFilterOrder;
    }

    public int getPreFilterOrder() {
        return this.preFilterOrder;
    }

    public void setPreFilterOrder(int preFilterOrder) {
        this.preFilterOrder = preFilterOrder;
    }

    public static class Policy {
        @NotNull
        private Long refreshInterval = TimeUnit.MINUTES.toSeconds(1L);
        private Long limit;
        private Long quota;
        @NotNull
        private boolean breakOnMatch;
        @Valid
        @NotNull
        @NestedConfigurationProperty
        private List<MatchType> type = Lists.newArrayList();

        public Long getRefreshInterval() {
            return this.refreshInterval;
        }

        public void setRefreshInterval(Long refreshInterval) {
            this.refreshInterval = refreshInterval;
        }

        public Long getLimit() {
            return this.limit;
        }

        public void setLimit(Long limit) {
            this.limit = limit;
        }

        public Long getQuota() {
            return this.quota;
        }

        public void setQuota(Long quota) {
            this.quota = quota;
        }

        public boolean isBreakOnMatch() {
            return this.breakOnMatch;
        }

        public void setBreakOnMatch(boolean breakOnMatch) {
            this.breakOnMatch = breakOnMatch;
        }

        public List<MatchType> getType() {
            return this.type;
        }

        public void setType(List<MatchType> type) {
            this.type = type;
        }

        public static class MatchType {
            @Valid
            @NotNull
            private RateLimitType type;
            private String matcher;

            public MatchType(@Valid @NotNull RateLimitType type, String matcher) {
                this.type = type;
                this.matcher = matcher;
            }

            public boolean apply(HttpServletRequest request, Route route, RateLimitUtils rateLimitUtils) {
                return StringUtils.isEmpty((CharSequence)this.matcher) || this.type.apply(request, route, rateLimitUtils, this.matcher);
            }

            public String key(HttpServletRequest request, Route route, RateLimitUtils rateLimitUtils) {
                return this.type.key(request, route, rateLimitUtils, this.matcher) + (StringUtils.isEmpty((CharSequence)this.matcher) ? "" : ":" + this.matcher);
            }

            public RateLimitType getType() {
                return this.type;
            }

            public void setType(RateLimitType type) {
                this.type = type;
            }

            public String getMatcher() {
                return this.matcher;
            }

            public void setMatcher(String matcher) {
                this.matcher = matcher;
            }
        }
    }
}

