/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.support;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitKeyGenerator;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitUtils;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import java.util.StringJoiner;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.netflix.zuul.filters.Route;

public class DefaultRateLimitKeyGenerator
implements RateLimitKeyGenerator {
    private final RateLimitProperties properties;
    private final RateLimitUtils rateLimitUtils;

    public DefaultRateLimitKeyGenerator(RateLimitProperties properties, RateLimitUtils rateLimitUtils) {
        this.properties = properties;
        this.rateLimitUtils = rateLimitUtils;
    }

    @Override
    public String key(HttpServletRequest request, Route route, RateLimitProperties.Policy policy) {
        StringJoiner joiner = new StringJoiner(":");
        joiner.add(this.properties.getKeyPrefix());
        if (route != null) {
            joiner.add(route.getId());
        }
        policy.getType().forEach(matchType -> {
            String key = matchType.key(request, route, this.rateLimitUtils);
            if (StringUtils.isNotEmpty((CharSequence)key)) {
                joiner.add(key);
            }
        });
        return joiner.toString();
    }
}

