/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitUtils;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.web.util.UrlPathHelper;

abstract class AbstractRateLimitFilter
extends ZuulFilter {
    private final RateLimitProperties properties;
    private final RouteLocator routeLocator;
    private final UrlPathHelper urlPathHelper;
    private final RateLimitUtils rateLimitUtils;
    private boolean alreadyLimited;

    AbstractRateLimitFilter(RateLimitProperties properties, RouteLocator routeLocator, UrlPathHelper urlPathHelper, RateLimitUtils rateLimitUtils) {
        this.properties = properties;
        this.routeLocator = routeLocator;
        this.urlPathHelper = urlPathHelper;
        this.rateLimitUtils = rateLimitUtils;
    }

    public boolean shouldFilter() {
        HttpServletRequest request = RequestContext.getCurrentContext().getRequest();
        return this.properties.isEnabled() && !this.policy(this.route(request), request).isEmpty();
    }

    Route route(HttpServletRequest request) {
        Route route = (Route)RequestContext.getCurrentContext().get((Object)"rateLimitRequestRoute");
        if (route != null) {
            return route;
        }
        String requestURI = this.urlPathHelper.getPathWithinApplication(request);
        route = this.routeLocator.getMatchingRoute(requestURI);
        this.addObjectToRequest("rateLimitRequestRoute", route);
        return route;
    }

    protected List<RateLimitProperties.Policy> policy(Route route, HttpServletRequest request) {
        List<RateLimitProperties.Policy> policies = (List<RateLimitProperties.Policy>)RequestContext.getCurrentContext().get((Object)"rateLimitRequestPolicy");
        if (policies != null) {
            return policies;
        }
        String routeId = route != null ? route.getId() : null;
        this.alreadyLimited = false;
        policies = this.properties.getPolicies(routeId).stream().filter(policy -> this.applyPolicy(request, route, (RateLimitProperties.Policy)policy)).collect(Collectors.toList());
        this.addObjectToRequest("rateLimitRequestPolicy", policies);
        return policies;
    }

    private void addObjectToRequest(String key, Object object) {
        if (object != null) {
            RequestContext.getCurrentContext().put((Object)key, object);
        }
    }

    private boolean applyPolicy(HttpServletRequest request, Route route, RateLimitProperties.Policy policy) {
        List<RateLimitProperties.Policy.MatchType> types = policy.getType();
        boolean tmp = this.alreadyLimited;
        if (policy.isBreakOnMatch() && types.stream().allMatch(type -> type.apply(request, route, this.rateLimitUtils))) {
            this.alreadyLimited = true;
        }
        return (types.isEmpty() || types.stream().allMatch(type -> type.apply(request, route, this.rateLimitUtils))) && !tmp;
    }
}

