/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitUtils;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.web.util.UrlPathHelper;

public abstract class AbstractRateLimitFilter
extends ZuulFilter {
    private final RateLimitProperties properties;
    private final RouteLocator routeLocator;
    private final UrlPathHelper urlPathHelper;
    private final RateLimitUtils rateLimitUtils;
    private boolean alreadyLimited;

    public boolean shouldFilter() {
        HttpServletRequest request = RequestContext.getCurrentContext().getRequest();
        return this.properties.isEnabled() && !this.policy(this.route(request), request).isEmpty();
    }

    Route route(HttpServletRequest request) {
        String requestURI = this.urlPathHelper.getPathWithinApplication(request);
        return this.routeLocator.getMatchingRoute(requestURI);
    }

    protected List<RateLimitProperties.Policy> policy(Route route, HttpServletRequest request) {
        String routeId = Optional.ofNullable(route).map(Route::getId).orElse(null);
        this.alreadyLimited = false;
        return this.properties.getPolicies(routeId).stream().filter(policy -> this.applyPolicy(request, route, (RateLimitProperties.Policy)policy)).collect(Collectors.toList());
    }

    private boolean applyPolicy(HttpServletRequest request, Route route, RateLimitProperties.Policy policy) {
        List<RateLimitProperties.Policy.MatchType> types = policy.getType();
        boolean tmp = this.alreadyLimited;
        if (policy.isBreakOnMatch() && types.stream().allMatch(type -> type.apply(request, route, this.rateLimitUtils))) {
            this.alreadyLimited = true;
        }
        return (types.isEmpty() || types.stream().allMatch(type -> type.apply(request, route, this.rateLimitUtils))) && !tmp;
    }

    public AbstractRateLimitFilter(RateLimitProperties properties, RouteLocator routeLocator, UrlPathHelper urlPathHelper, RateLimitUtils rateLimitUtils) {
        this.properties = properties;
        this.routeLocator = routeLocator;
        this.urlPathHelper = urlPathHelper;
        this.rateLimitUtils = rateLimitUtils;
    }
}

