/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitUtils;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitRepository;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitType;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.validators.Policies;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.validation.annotation.Validated;

@Validated
@RefreshScope
@ConfigurationProperties(value="zuul.ratelimit")
public class RateLimitProperties {
    public static final String PREFIX = "zuul.ratelimit";
    @Valid
    @NotNull
    @Policies
    private List<Policy> defaultPolicyList = Lists.newArrayList();
    @Valid
    @NotNull
    @Policies
    private Map<String, List<Policy>> policyList = Maps.newHashMap();
    private boolean behindProxy;
    private boolean enabled;
    private boolean addResponseHeaders = true;
    @NotNull
    @Value(value="${spring.application.name:rate-limit-application}")
    private String keyPrefix;
    @NotNull
    private RateLimitRepository repository;
    private int postFilterOrder = 990;
    private int preFilterOrder = -1;

    public List<Policy> getPolicies(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return this.defaultPolicyList;
        }
        return this.policyList.getOrDefault(key, this.defaultPolicyList);
    }

    public List<Policy> getDefaultPolicyList() {
        return this.defaultPolicyList;
    }

    public Map<String, List<Policy>> getPolicyList() {
        return this.policyList;
    }

    public boolean isBehindProxy() {
        return this.behindProxy;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAddResponseHeaders() {
        return this.addResponseHeaders;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public RateLimitRepository getRepository() {
        return this.repository;
    }

    public int getPostFilterOrder() {
        return this.postFilterOrder;
    }

    public int getPreFilterOrder() {
        return this.preFilterOrder;
    }

    public void setDefaultPolicyList(List<Policy> defaultPolicyList) {
        this.defaultPolicyList = defaultPolicyList;
    }

    public void setPolicyList(Map<String, List<Policy>> policyList) {
        this.policyList = policyList;
    }

    public void setBehindProxy(boolean behindProxy) {
        this.behindProxy = behindProxy;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAddResponseHeaders(boolean addResponseHeaders) {
        this.addResponseHeaders = addResponseHeaders;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public void setRepository(RateLimitRepository repository) {
        this.repository = repository;
    }

    public void setPostFilterOrder(int postFilterOrder) {
        this.postFilterOrder = postFilterOrder;
    }

    public void setPreFilterOrder(int preFilterOrder) {
        this.preFilterOrder = preFilterOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RateLimitProperties)) {
            return false;
        }
        RateLimitProperties other = (RateLimitProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Policy> this$defaultPolicyList = this.getDefaultPolicyList();
        List<Policy> other$defaultPolicyList = other.getDefaultPolicyList();
        if (this$defaultPolicyList == null ? other$defaultPolicyList != null : !((Object)this$defaultPolicyList).equals(other$defaultPolicyList)) {
            return false;
        }
        Map<String, List<Policy>> this$policyList = this.getPolicyList();
        Map<String, List<Policy>> other$policyList = other.getPolicyList();
        if (this$policyList == null ? other$policyList != null : !((Object)this$policyList).equals(other$policyList)) {
            return false;
        }
        if (this.isBehindProxy() != other.isBehindProxy()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isAddResponseHeaders() != other.isAddResponseHeaders()) {
            return false;
        }
        String this$keyPrefix = this.getKeyPrefix();
        String other$keyPrefix = other.getKeyPrefix();
        if (this$keyPrefix == null ? other$keyPrefix != null : !this$keyPrefix.equals(other$keyPrefix)) {
            return false;
        }
        RateLimitRepository this$repository = this.getRepository();
        RateLimitRepository other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !((Object)((Object)this$repository)).equals((Object)other$repository)) {
            return false;
        }
        if (this.getPostFilterOrder() != other.getPostFilterOrder()) {
            return false;
        }
        return this.getPreFilterOrder() == other.getPreFilterOrder();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RateLimitProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Policy> $defaultPolicyList = this.getDefaultPolicyList();
        result = result * 59 + ($defaultPolicyList == null ? 43 : ((Object)$defaultPolicyList).hashCode());
        Map<String, List<Policy>> $policyList = this.getPolicyList();
        result = result * 59 + ($policyList == null ? 43 : ((Object)$policyList).hashCode());
        result = result * 59 + (this.isBehindProxy() ? 79 : 97);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isAddResponseHeaders() ? 79 : 97);
        String $keyPrefix = this.getKeyPrefix();
        result = result * 59 + ($keyPrefix == null ? 43 : $keyPrefix.hashCode());
        RateLimitRepository $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : ((Object)((Object)$repository)).hashCode());
        result = result * 59 + this.getPostFilterOrder();
        result = result * 59 + this.getPreFilterOrder();
        return result;
    }

    public String toString() {
        return "RateLimitProperties(defaultPolicyList=" + this.getDefaultPolicyList() + ", policyList=" + this.getPolicyList() + ", behindProxy=" + this.isBehindProxy() + ", enabled=" + this.isEnabled() + ", addResponseHeaders=" + this.isAddResponseHeaders() + ", keyPrefix=" + this.getKeyPrefix() + ", repository=" + (Object)((Object)this.getRepository()) + ", postFilterOrder=" + this.getPostFilterOrder() + ", preFilterOrder=" + this.getPreFilterOrder() + ")";
    }

    public static class Policy {
        @NotNull
        private Long refreshInterval = TimeUnit.MINUTES.toSeconds(1L);
        private Long limit;
        private Long quota;
        @NotNull
        private boolean breakOnMatch;
        @Valid
        @NotNull
        private List<MatchType> type = Lists.newArrayList();

        public Long getRefreshInterval() {
            return this.refreshInterval;
        }

        public Long getLimit() {
            return this.limit;
        }

        public Long getQuota() {
            return this.quota;
        }

        public boolean isBreakOnMatch() {
            return this.breakOnMatch;
        }

        public List<MatchType> getType() {
            return this.type;
        }

        public void setRefreshInterval(Long refreshInterval) {
            this.refreshInterval = refreshInterval;
        }

        public void setLimit(Long limit) {
            this.limit = limit;
        }

        public void setQuota(Long quota) {
            this.quota = quota;
        }

        public void setBreakOnMatch(boolean breakOnMatch) {
            this.breakOnMatch = breakOnMatch;
        }

        public void setType(List<MatchType> type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Policy)) {
                return false;
            }
            Policy other = (Policy)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$refreshInterval = this.getRefreshInterval();
            Long other$refreshInterval = other.getRefreshInterval();
            if (this$refreshInterval == null ? other$refreshInterval != null : !((Object)this$refreshInterval).equals(other$refreshInterval)) {
                return false;
            }
            Long this$limit = this.getLimit();
            Long other$limit = other.getLimit();
            if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
                return false;
            }
            Long this$quota = this.getQuota();
            Long other$quota = other.getQuota();
            if (this$quota == null ? other$quota != null : !((Object)this$quota).equals(other$quota)) {
                return false;
            }
            if (this.isBreakOnMatch() != other.isBreakOnMatch()) {
                return false;
            }
            List<MatchType> this$type = this.getType();
            List<MatchType> other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)this$type).equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Policy;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $refreshInterval = this.getRefreshInterval();
            result = result * 59 + ($refreshInterval == null ? 43 : ((Object)$refreshInterval).hashCode());
            Long $limit = this.getLimit();
            result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
            Long $quota = this.getQuota();
            result = result * 59 + ($quota == null ? 43 : ((Object)$quota).hashCode());
            result = result * 59 + (this.isBreakOnMatch() ? 79 : 97);
            List<MatchType> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            return result;
        }

        public String toString() {
            return "RateLimitProperties.Policy(refreshInterval=" + this.getRefreshInterval() + ", limit=" + this.getLimit() + ", quota=" + this.getQuota() + ", breakOnMatch=" + this.isBreakOnMatch() + ", type=" + this.getType() + ")";
        }

        public static class MatchType {
            @Valid
            @NotNull
            private RateLimitType type;
            private String matcher;

            public boolean apply(HttpServletRequest request, Route route, RateLimitUtils rateLimitUtils) {
                return StringUtils.isEmpty((CharSequence)this.matcher) || this.type.apply(request, route, rateLimitUtils, this.matcher);
            }

            public String key(HttpServletRequest request, Route route, RateLimitUtils rateLimitUtils) {
                return this.type.key(request, route, rateLimitUtils, this.matcher) + (StringUtils.isEmpty((CharSequence)this.matcher) ? "" : ":" + this.matcher);
            }

            public RateLimitType getType() {
                return this.type;
            }

            public String getMatcher() {
                return this.matcher;
            }

            public void setType(RateLimitType type) {
                this.type = type;
            }

            public void setMatcher(String matcher) {
                this.matcher = matcher;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MatchType)) {
                    return false;
                }
                MatchType other = (MatchType)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                RateLimitType this$type = this.getType();
                RateLimitType other$type = other.getType();
                if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                    return false;
                }
                String this$matcher = this.getMatcher();
                String other$matcher = other.getMatcher();
                return !(this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher));
            }

            protected boolean canEqual(Object other) {
                return other instanceof MatchType;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                RateLimitType $type = this.getType();
                result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
                String $matcher = this.getMatcher();
                result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
                return result;
            }

            public String toString() {
                return "RateLimitProperties.Policy.MatchType(type=" + (Object)((Object)this.getType()) + ", matcher=" + this.getMatcher() + ")";
            }

            public MatchType(RateLimitType type, String matcher) {
                this.type = type;
                this.matcher = matcher;
            }
        }
    }
}

