/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.text.TextUtils;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.Base64OutputStream;
import com.loopj.android.http.JsonValueInterface;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.ResponseHandlerInterface;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonStreamerEntity
implements HttpEntity {
    private static final String LOG_TAG = "JsonStreamerEntity";
    private static final UnsupportedOperationException ERR_UNSUPPORTED = new UnsupportedOperationException("Unsupported operation in this implementation.");
    private static final int BUFFER_SIZE = 4096;
    private final byte[] buffer = new byte[4096];
    private static final byte[] JSON_TRUE = "true".getBytes();
    private static final byte[] JSON_FALSE = "false".getBytes();
    private static final byte[] JSON_NULL = "null".getBytes();
    private static final byte[] STREAM_NAME = JsonStreamerEntity.escape("name");
    private static final byte[] STREAM_TYPE = JsonStreamerEntity.escape("type");
    private static final byte[] STREAM_CONTENTS = JsonStreamerEntity.escape("contents");
    private static final Header HEADER_JSON_CONTENT = new BasicHeader("Content-Type", "application/json");
    private static final Header HEADER_GZIP_ENCODING = new BasicHeader("Content-Encoding", "gzip");
    private final Map<String, Object> jsonParams = new HashMap<String, Object>();
    private final Header contentEncoding;
    private final byte[] elapsedField;
    private final ResponseHandlerInterface progressHandler;

    public JsonStreamerEntity(ResponseHandlerInterface progressHandler, boolean useGZipCompression, String elapsedField) {
        this.progressHandler = progressHandler;
        this.contentEncoding = useGZipCompression ? HEADER_GZIP_ENCODING : null;
        this.elapsedField = TextUtils.isEmpty((CharSequence)elapsedField) ? null : JsonStreamerEntity.escape(elapsedField);
    }

    public void addPart(String key, Object value) {
        this.jsonParams.put(key, value);
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isStreaming() {
        return false;
    }

    public long getContentLength() {
        return -1L;
    }

    public Header getContentEncoding() {
        return this.contentEncoding;
    }

    public Header getContentType() {
        return HEADER_JSON_CONTENT;
    }

    public void consumeContent() throws IOException, UnsupportedOperationException {
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw ERR_UNSUPPORTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalStateException("Output stream cannot be null.");
        }
        long now = System.currentTimeMillis();
        OutputStream os = this.contentEncoding != null ? new GZIPOutputStream(out, 4096) : out;
        os.write(123);
        Set<String> keys = this.jsonParams.keySet();
        int keysCount = keys.size();
        if (0 < keysCount) {
            int keysProcessed = 0;
            for (String key : keys) {
                ++keysProcessed;
                try {
                    Object value = this.jsonParams.get(key);
                    os.write(JsonStreamerEntity.escape(key));
                    os.write(58);
                    if (value == null) {
                        os.write(JSON_NULL);
                        continue;
                    }
                    boolean isFileWrapper = value instanceof RequestParams.FileWrapper;
                    if (isFileWrapper || value instanceof RequestParams.StreamWrapper) {
                        os.write(123);
                        if (isFileWrapper) {
                            this.writeToFromFile(os, (RequestParams.FileWrapper)value);
                        } else {
                            this.writeToFromStream(os, (RequestParams.StreamWrapper)value);
                        }
                        os.write(125);
                        continue;
                    }
                    if (value instanceof JsonValueInterface) {
                        os.write(((JsonValueInterface)value).getEscapedJsonValue());
                        continue;
                    }
                    if (value instanceof JSONObject) {
                        os.write(value.toString().getBytes());
                        continue;
                    }
                    if (value instanceof JSONArray) {
                        os.write(value.toString().getBytes());
                        continue;
                    }
                    if (value instanceof Boolean) {
                        os.write((Boolean)value != false ? JSON_TRUE : JSON_FALSE);
                        continue;
                    }
                    if (value instanceof Long) {
                        os.write((((Number)value).longValue() + "").getBytes());
                        continue;
                    }
                    if (value instanceof Double) {
                        os.write((((Number)value).doubleValue() + "").getBytes());
                        continue;
                    }
                    if (value instanceof Float) {
                        os.write((((Number)value).floatValue() + "").getBytes());
                        continue;
                    }
                    if (value instanceof Integer) {
                        os.write((((Number)value).intValue() + "").getBytes());
                        continue;
                    }
                    os.write(JsonStreamerEntity.escape(value.toString()));
                }
                finally {
                    if (this.elapsedField == null && keysProcessed >= keysCount) continue;
                    os.write(44);
                }
            }
            long elapsedTime = System.currentTimeMillis() - now;
            if (this.elapsedField != null) {
                os.write(this.elapsedField);
                os.write(58);
                os.write((elapsedTime + "").getBytes());
            }
            AsyncHttpClient.log.i(LOG_TAG, "Uploaded JSON in " + Math.floor(elapsedTime / 1000L) + " seconds");
        }
        os.write(125);
        os.flush();
        AsyncHttpClient.silentCloseOutputStream(os);
    }

    private void writeToFromStream(OutputStream os, RequestParams.StreamWrapper entry) throws IOException {
        int bytesRead;
        this.writeMetaData(os, entry.name, entry.contentType);
        Base64OutputStream bos = new Base64OutputStream(os, 18);
        while ((bytesRead = entry.inputStream.read(this.buffer)) != -1) {
            bos.write(this.buffer, 0, bytesRead);
        }
        AsyncHttpClient.silentCloseOutputStream(bos);
        this.endMetaData(os);
        if (entry.autoClose) {
            AsyncHttpClient.silentCloseInputStream(entry.inputStream);
        }
    }

    private void writeToFromFile(OutputStream os, RequestParams.FileWrapper wrapper) throws IOException {
        int bytesRead;
        this.writeMetaData(os, wrapper.file.getName(), wrapper.contentType);
        long bytesWritten = 0L;
        long totalSize = wrapper.file.length();
        FileInputStream in = new FileInputStream(wrapper.file);
        Base64OutputStream bos = new Base64OutputStream(os, 18);
        while ((bytesRead = in.read(this.buffer)) != -1) {
            bos.write(this.buffer, 0, bytesRead);
            this.progressHandler.sendProgressMessage(bytesWritten += (long)bytesRead, totalSize);
        }
        AsyncHttpClient.silentCloseOutputStream(bos);
        this.endMetaData(os);
        AsyncHttpClient.silentCloseInputStream(in);
    }

    private void writeMetaData(OutputStream os, String name, String contentType) throws IOException {
        os.write(STREAM_NAME);
        os.write(58);
        os.write(JsonStreamerEntity.escape(name));
        os.write(44);
        os.write(STREAM_TYPE);
        os.write(58);
        os.write(JsonStreamerEntity.escape(contentType));
        os.write(44);
        os.write(STREAM_CONTENTS);
        os.write(58);
        os.write(34);
    }

    private void endMetaData(OutputStream os) throws IOException {
        os.write(34);
    }

    static byte[] escape(String string) {
        if (string == null) {
            return JSON_NULL;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append('\"');
        int length = string.length();
        int pos = -1;
        block9: while (++pos < length) {
            char ch = string.charAt(pos);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
            }
            if (ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                String intString = Integer.toHexString(ch);
                sb.append("\\u");
                int intLength = 4 - intString.length();
                for (int zero = 0; zero < intLength; ++zero) {
                    sb.append('0');
                }
                sb.append(intString.toUpperCase(Locale.US));
                continue;
            }
            sb.append(ch);
        }
        sb.append('\"');
        return sb.toString().getBytes();
    }
}

