/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.solr;

import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseHit;
import com.browseengine.bobo.api.BrowseRequest;
import com.browseengine.bobo.api.BrowseResult;
import com.browseengine.bobo.api.MappedFacetAccessible;
import com.browseengine.bobo.util.ListMerger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;

public class DispatchUtil {
    private static Logger logger = Logger.getLogger(DispatchUtil.class);
    static HttpClient client;
    static int soTimeout;
    static int connectionTimeout;

    public static BrowseResult broadcast(ExecutorService threadPool, SolrParams boboSolrParams, BrowseRequest req, String[] baseURL, int maxRetry) {
        long start = System.currentTimeMillis();
        Future[] futureList = new Future[baseURL.length];
        for (int i = 0; i < baseURL.length; ++i) {
            DispatchSolrParams dispatchParams = new DispatchSolrParams(boboSolrParams);
            Callable<BrowseResult> callable = DispatchUtil.newCallable(dispatchParams, baseURL[i], maxRetry);
            futureList[i] = threadPool.submit(callable);
        }
        ArrayList<Map> facetList = new ArrayList<Map>(baseURL.length);
        ArrayList<Iterator<BrowseHit>> iteratorList = new ArrayList<Iterator<BrowseHit>>(baseURL.length);
        int numHits = 0;
        int totalDocs = 0;
        for (int i = 0; i < futureList.length; ++i) {
            try {
                BrowseResult res = (BrowseResult)futureList[i].get();
                BrowseHit[] hits = res.getHits();
                if (hits != null) {
                    for (BrowseHit hit : hits) {
                        hit.setDocid(hit.getDocid() + totalDocs);
                    }
                }
                iteratorList.add(Arrays.asList(res.getHits()).iterator());
                Map facetMap = res.getFacetMap();
                if (facetMap != null) {
                    facetList.add(facetMap);
                }
                numHits += res.getNumHits();
                totalDocs += res.getTotalDocs();
                continue;
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (ExecutionException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        Map mergedFacetMap = ListMerger.mergeSimpleFacetContainers(facetList, (BrowseRequest)req);
        Comparator<BrowseHit> comparator = new Comparator<BrowseHit>(){

            @Override
            public int compare(BrowseHit o1, BrowseHit o2) {
                Comparable c1 = o1.getComparable();
                Comparable c2 = o2.getComparable();
                if (c1 == null || c2 == null) {
                    return o2.getDocid() - o1.getDocid();
                }
                return c1.compareTo(c2);
            }
        };
        List mergedList = req.getCount() > 0 ? ListMerger.mergeLists((int)req.getOffset(), (int)req.getCount(), (Iterator[])iteratorList.toArray(new Iterator[iteratorList.size()]), (Comparator)comparator) : Collections.EMPTY_LIST;
        BrowseHit[] hits = mergedList.toArray(new BrowseHit[mergedList.size()]);
        long end = System.currentTimeMillis();
        BrowseResult merged = new BrowseResult();
        merged.setHits(hits);
        merged.setNumHits(numHits);
        merged.setTotalDocs(totalDocs);
        merged.setTime(end - start);
        merged.addAll(mergedFacetMap);
        return merged;
    }

    private static BrowseResult parseResponse(QueryResponse res) throws UnsupportedEncodingException {
        SolrDocumentList solrDocs;
        BrowseResult result = new BrowseResult();
        result.setTime(res.getElapsedTime());
        List facetFields = res.getFacetFields();
        if (facetFields != null) {
            HashMap<String, MappedFacetAccessible> facetMap = new HashMap<String, MappedFacetAccessible>();
            for (FacetField ff : facetFields) {
                String fieldName = ff.getName();
                List countList = ff.getValues();
                if (countList == null) continue;
                BrowseFacet[] facets = new BrowseFacet[countList.size()];
                int i = 0;
                for (FacetField.Count count : countList) {
                    facets[i++] = new BrowseFacet(count.getName(), (int)count.getCount());
                }
                facetMap.put(fieldName, new MappedFacetAccessible(facets));
            }
            result.addAll(facetMap);
        }
        if ((solrDocs = res.getResults()) != null) {
            result.setNumHits((int)solrDocs.getNumFound());
            ArrayList<BrowseHit> hits = new ArrayList<BrowseHit>(solrDocs.size());
            for (SolrDocument doc : solrDocs) {
                BrowseHit hit = new BrowseHit();
                HashMap<String, String[]> fieldMap = new HashMap<String, String[]>();
                Collection fieldNames = doc.getFieldNames();
                for (String fn : fieldNames) {
                    Collection fvals = doc.getFieldNames();
                    fieldMap.put(fn, fvals.toArray(new String[fvals.size()]));
                }
                hit.setFieldValues(fieldMap);
                hits.add(hit);
            }
            result.setHits(hits.toArray(new BrowseHit[hits.size()]));
        }
        return result;
    }

    private static BrowseResult doShardCall(SolrServer solrSvr, SolrParams params, String baseURL, int maxRetry) throws SolrException, SolrServerException, IOException {
        return DispatchUtil.parseResponse(solrSvr.query(params));
    }

    private static Callable<BrowseResult> newCallable(final SolrParams req, final String baseURL, final int maxRetry) {
        return new Callable<BrowseResult>(){

            @Override
            public BrowseResult call() throws Exception {
                CommonsHttpSolrServer solrSvr = new CommonsHttpSolrServer(baseURL, client);
                return DispatchUtil.doShardCall((SolrServer)solrSvr, req, baseURL, maxRetry);
            }
        };
    }

    static {
        soTimeout = 0;
        connectionTimeout = 0;
        MultiThreadedHttpConnectionManager mgr = new MultiThreadedHttpConnectionManager();
        mgr.getParams().setDefaultMaxConnectionsPerHost(20);
        mgr.getParams().setMaxTotalConnections(10000);
        mgr.getParams().setConnectionTimeout(connectionTimeout);
        mgr.getParams().setSoTimeout(soTimeout);
        client = new HttpClient((HttpConnectionManager)mgr);
    }

    private static class DispatchSolrParams
    extends SolrParams {
        private int offset;
        private int count;
        private SolrParams _params;

        DispatchSolrParams(SolrParams params) {
            this._params = params;
            this.offset = params.getInt("start", 0);
            this.count = params.getInt("rows", 0);
        }

        public String get(String name) {
            if ("start".equals(name)) {
                return "0";
            }
            if ("rows".equals(name)) {
                return String.valueOf(this.offset + this.count);
            }
            if ("shards".equals(name)) {
                return null;
            }
            return this._params.get(name);
        }

        public Iterator<String> getParameterNamesIterator() {
            return this._params.getParameterNamesIterator();
        }

        public String[] getParams(String name) {
            if ("shards".equals(name)) {
                return null;
            }
            return this._params.getParams(name);
        }
    }
}

