/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.solr;

import com.browseengine.bobo.api.BrowseException;
import com.browseengine.bobo.api.BrowseRequest;
import com.browseengine.bobo.api.BrowseSelection;
import com.browseengine.bobo.api.FacetSpec;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.params.SolrParams;

public class BoboRequestBuilder {
    public static final String BOBO_PREFIX = "bobo";
    public static final String BOBO_FIELD_SEL_PREFIX = "selection";
    public static final String BOBO_FIELD_SEL_OP = "selection.op";
    public static final String BOBO_FIELD_SEL_NOT = "selection.not";
    public static final String BOBO_FACET_EXPAND = "facet.expand";
    public static final Logger logger = Logger.getLogger(BoboRequestBuilder.class);
    private static HashSet<String> UnsupportedSolrFacetParams = new HashSet();
    private static final Pattern splitList;

    public static void applyFacetExpand(SolrQuery params, String name, boolean expand) {
        params.add("f.bobo." + name + "." + BOBO_FACET_EXPAND, new String[]{String.valueOf(expand)});
    }

    public static void applySelectionOperation(SolrQuery params, String name, BrowseSelection.ValueOperation op) {
        String val = BrowseSelection.ValueOperation.ValueOperationAnd.equals((Object)op) ? "and" : "or";
        params.add("f.bobo." + name + "." + BOBO_FIELD_SEL_OP, new String[]{val});
    }

    public static BrowseSelection.ValueOperation getSelectionOperation(SolrParams params, String name) throws BrowseException {
        String selop = BoboRequestBuilder.getBoboParam(params, name, BOBO_FIELD_SEL_OP);
        if (selop != null) {
            if ("and".equals(selop)) {
                return BrowseSelection.ValueOperation.ValueOperationAnd;
            }
            if ("or".equals(selop)) {
                return BrowseSelection.ValueOperation.ValueOperationOr;
            }
            throw new BrowseException(name + ": selection operation: " + selop + " not supported");
        }
        return BrowseSelection.ValueOperation.ValueOperationOr;
    }

    public static boolean isFacetExpand(SolrParams params, String facetField) {
        return BoboRequestBuilder.getBoboParamBool(params, facetField, BOBO_FACET_EXPAND, false);
    }

    public static void applySelectionNotValues(SolrQuery params, String name, String ... notvalues) {
        params.add("f.bobo." + name + "." + BOBO_FIELD_SEL_NOT, notvalues);
    }

    public static String[] getSelectionNotValues(SolrParams params, String name) {
        return BoboRequestBuilder.getBoboParams(params, name, BOBO_FIELD_SEL_NOT);
    }

    public static void applySelectionProperties(SolrQuery params, String name, Map<String, String> props) {
        if (props != null && props.size() > 0) {
            Set<Map.Entry<String, String>> entries = props.entrySet();
            String[] propvals = new String[entries.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : entries) {
                String val = entry.getKey() + ":" + entry.getValue();
                propvals[i++] = val;
            }
            params.add("f.bobo." + name + "." + BOBO_FIELD_SEL_PREFIX + ".prop", propvals);
        }
    }

    public static Map<String, String> getSelectionProperties(SolrParams params, String name) {
        return BoboRequestBuilder.getBoboParamProps(params, name, BOBO_FIELD_SEL_PREFIX);
    }

    private static String[] getBoboParams(SolrParams solrParams, String field, String param) {
        return solrParams.getFieldParams("bobo." + field, param);
    }

    private static String getBoboParam(SolrParams solrParams, String field, String param) {
        return solrParams.getFieldParam("bobo." + field, param);
    }

    private static boolean getBoboParamBool(SolrParams solrParams, String field, String param, boolean defaultBool) {
        return solrParams.getFieldBool("bobo." + field, param, defaultBool);
    }

    private static Map<String, String> getBoboParamProps(SolrParams solrParams, String field, String name) {
        HashMap<String, String> propMap = new HashMap<String, String>();
        String[] props = BoboRequestBuilder.getBoboParams(solrParams, field, name + ".prop");
        if (props != null && props.length > 0) {
            for (String prop : props) {
                String[] parts = prop.split(":");
                if (parts.length != 2) continue;
                propMap.put(parts[0], parts[1]);
            }
        }
        return propMap;
    }

    private static void fillBoboSelections(BrowseRequest req, SolrParams params) throws BrowseException {
        String[] facetQueries = params.getParams("facet.query");
        if (facetQueries != null && facetQueries.length != 0) {
            HashMap<String, BrowseSelection> selMap = new HashMap<String, BrowseSelection>();
            for (String facetQuery : facetQueries) {
                Map<String, String> propMaps;
                String[] parts = facetQuery.split(":");
                String name = parts[0];
                String valval = parts[1];
                String[] vals = valval.split(",");
                if (vals.length <= 0) continue;
                BrowseSelection sel = (BrowseSelection)selMap.get(name);
                if (sel == null) {
                    sel = new BrowseSelection(name);
                    selMap.put(name, sel);
                }
                for (String val : vals) {
                    sel.addValue(val);
                }
                sel.setSelectionOperation(BoboRequestBuilder.getSelectionOperation(params, name));
                String[] selNot = BoboRequestBuilder.getSelectionNotValues(params, name);
                if (selNot != null && selNot.length > 0) {
                    sel.setNotValues(selNot);
                }
                if ((propMaps = BoboRequestBuilder.getSelectionProperties(params, name)) == null || propMaps.size() <= 0) continue;
                sel.setSelectionProperties(propMaps);
            }
            if (selMap.size() > 0) {
                Collection sels = selMap.values();
                for (BrowseSelection sel : sels) {
                    req.addSelection(sel);
                }
            }
        }
    }

    public static String[] split(String value) {
        return splitList.split(value.trim(), 0);
    }

    private static boolean parseReturnedFields(String fl, Set<String> set) {
        String[] flst;
        boolean doScore = false;
        if (fl != null && (flst = BoboRequestBuilder.split(fl)).length > 0 && (flst.length != 1 || flst[0].length() != 0)) {
            for (String fname : flst) {
                if ("score".equalsIgnoreCase(fname)) {
                    doScore = true;
                    continue;
                }
                set.add(fname);
            }
        }
        return doScore;
    }

    private static FacetSpec.FacetSortSpec parseFacetSort(String facetSortString, FacetSpec.FacetSortSpec defaultSort) {
        FacetSpec.FacetSortSpec defaultFacetSortSpec = "true".equals(facetSortString) || "count".equals(facetSortString) ? FacetSpec.FacetSortSpec.OrderHitsDesc : ("false".equals(facetSortString) || "index".equals(facetSortString) ? FacetSpec.FacetSortSpec.OrderValueAsc : defaultSort);
        return defaultFacetSortSpec;
    }

    public static BrowseRequest buildRequest(SolrParams params, Query query, Sort sort) throws BrowseException {
        SortField[] sortFields;
        int offset = params.getInt("start", 0);
        int count = params.getInt("rows", 10);
        int defaultMinCount = params.getInt("facet.mincount", 0);
        int defaultLimit = params.getInt("facet.limit", 100);
        if (defaultLimit < 0) {
            defaultLimit = Integer.MAX_VALUE;
        }
        String[] fields = params.getParams("facet.field");
        String facetSortString = params.get("facet.sort");
        FacetSpec.FacetSortSpec defaultFacetSortSpec = BoboRequestBuilder.parseFacetSort(facetSortString, FacetSpec.FacetSortSpec.OrderHitsDesc);
        BrowseRequest br = new BrowseRequest();
        br.setOffset(offset);
        br.setCount(count);
        br.setQuery(query);
        if (sort != null && (sortFields = sort.getSort()) != null && sortFields.length > 0) {
            br.setSort(sortFields);
        }
        BoboRequestBuilder.fillBoboSelections(br, params);
        if (params.getBool("facet", false) && fields != null) {
            for (String facetField : fields) {
                FacetSpec fspec = new FacetSpec();
                br.setFacetSpec(facetField, fspec);
                fspec.setMinHitCount(params.getFieldInt(facetField, "facet.mincount", defaultMinCount));
                fspec.setMaxCount(params.getFieldInt(facetField, "facet.limit", defaultLimit));
                fspec.setExpandSelection(BoboRequestBuilder.isFacetExpand(params, facetField));
                FacetSpec.FacetSortSpec sortSpec = BoboRequestBuilder.parseFacetSort(params.getFieldParam(facetField, "facet.sort", null), defaultFacetSortSpec);
                fspec.setOrderBy(sortSpec);
            }
        }
        return br;
    }

    static {
        UnsupportedSolrFacetParams.add("facet.prefix");
        UnsupportedSolrFacetParams.add("facet.query");
        UnsupportedSolrFacetParams.add("facet.method");
        UnsupportedSolrFacetParams.add("facet.offset");
        UnsupportedSolrFacetParams.add("facet.missing");
        splitList = Pattern.compile(",| ");
    }
}

