/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.solr;

import com.browseengine.bobo.api.BoboBrowser;
import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.api.BrowseFacet;
import com.browseengine.bobo.api.BrowseHit;
import com.browseengine.bobo.api.BrowseRequest;
import com.browseengine.bobo.api.BrowseResult;
import com.browseengine.bobo.api.FacetAccessible;
import com.browseengine.solr.BoboRequestBuilder;
import com.browseengine.solr.DispatchUtil;
import com.kamikaze.docidset.impl.AndDocIdSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.Weight;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SortSpec;
import org.apache.solr.util.SolrPluginUtils;

public class BoboFacetComponent
extends SearchComponent {
    private static final String THREAD_POOL_SIZE_PARAM = "thread_pool_size";
    private static final String MAX_SHARD_COUNT_PARAM = "max_shard_count";
    private ExecutorService _threadPool = null;
    private static Logger logger = Logger.getLogger(BoboFacetComponent.class);

    public void init(NamedList params) {
        int shardCount;
        int threadPoolSize;
        try {
            threadPoolSize = Integer.parseInt((String)params.get(THREAD_POOL_SIZE_PARAM));
        }
        catch (Exception e) {
            threadPoolSize = 100;
        }
        try {
            shardCount = Integer.parseInt((String)params.get(MAX_SHARD_COUNT_PARAM));
        }
        catch (Exception e) {
            shardCount = 10;
        }
        this._threadPool = Executors.newFixedThreadPool(threadPoolSize * shardCount);
    }

    public String getDescription() {
        return "Handle Bobo Faceting";
    }

    public String getSource() {
        return null;
    }

    public String getSourceId() {
        return null;
    }

    public String getVersion() {
        return null;
    }

    public void prepare(ResponseBuilder rb) throws IOException {
        if (rb.req.getParams().getBool("facet", false)) {
            rb.setNeedDocSet(true);
            rb.doFacets = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(ResponseBuilder rb) throws IOException {
        rb.stage = ResponseBuilder.STAGE_START;
        SolrParams params = rb.req.getParams();
        String fl = params.get("fl");
        int fieldFlags = 0;
        if (fl != null) {
            fieldFlags |= SolrPluginUtils.setReturnFields((String)fl, (SolrQueryResponse)rb.rsp);
        }
        rb.setFieldFlags(fieldFlags);
        String defType = params.get("defType");
        defType = defType == null ? QParserPlugin.DEFAULT_QTYPE : defType;
        String qString = params.get("q");
        if (qString == null || qString.length() == 0) {
            qString = "*:*";
        }
        if (rb.getQueryString() == null) {
            rb.setQueryString(qString);
        }
        try {
            QParser parser = QParser.getParser((String)rb.getQueryString(), (String)defType, (SolrQueryRequest)rb.req);
            rb.setQuery(parser.getQuery());
            rb.setSortSpec(parser.getSort(true));
            rb.setQparser(parser);
            String[] fqs = params.getParams("fq");
            if (fqs != null && fqs.length != 0) {
                ArrayList<Query> filters = rb.getFilters();
                if (filters == null) {
                    filters = new ArrayList<Query>();
                    rb.setFilters(filters);
                }
                for (String fq : fqs) {
                    if (fq == null || fq.trim().length() == 0) continue;
                    QParser fqp = QParser.getParser((String)fq, null, (SolrQueryRequest)rb.req);
                    filters.add(fqp.getQuery());
                }
            }
        }
        catch (ParseException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        Query query = rb.getQuery();
        SortSpec sortspec = rb.getSortSpec();
        Sort sort = null;
        if (sortspec != null) {
            sort = sortspec.getSort();
        }
        SolrParams solrParams = rb.req.getParams();
        String shardsVal = solrParams.get("shards", null);
        BrowseRequest br = null;
        try {
            br = BoboRequestBuilder.buildRequest(solrParams, query, sort);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        BrowseResult res = null;
        if (shardsVal == null && !solrParams.getBool("isShard", false)) {
            SolrIndexSearcher searcher = rb.req.getSearcher();
            SolrIndexReader solrReader = searcher.getReader();
            BoboIndexReader reader = (BoboIndexReader)solrReader.getWrappedReader();
            if (!(reader instanceof BoboIndexReader)) throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "invalid reader, please make sure BoboIndexReaderFactory is set.");
            try {
                List filters = rb.getFilters();
                if (filters != null) {
                    final ArrayList<1> docsets = new ArrayList<1>(filters.size());
                    for (Query filter : filters) {
                        Weight weight = filter.createWeight((Searcher)rb.req.getSearcher());
                        final Scorer scorer = weight.scorer((IndexReader)reader, false, true);
                        docsets.add(new DocIdSet(){

                            public DocIdSetIterator iterator() throws IOException {
                                return scorer;
                            }
                        });
                    }
                    if (docsets.size() > 0) {
                        br.setFilter(new Filter(){

                            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                                return new AndDocIdSet((List)docsets);
                            }
                        });
                    }
                }
                Set facetNames = reader.getFacetNames();
                Set returnFields = rb.rsp.getReturnFields();
                HashSet<String> storedFields = new HashSet<String>();
                if (returnFields != null) {
                    for (String fld : returnFields) {
                        if (facetNames.contains(fld)) continue;
                        storedFields.add(fld);
                    }
                    br.setFetchStoredFields(!storedFields.isEmpty());
                }
                BoboBrowser browser = new BoboBrowser(reader);
                res = browser.browse(br);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e.getMessage(), (Throwable)e);
            }
        } else {
            String[] shards = shardsVal.split(",");
            res = DispatchUtil.broadcast(this._threadPool, solrParams, br, shards, 5);
        }
        SolrDocumentList docList = new SolrDocumentList();
        docList.setNumFound((long)res.getNumHits());
        docList.setStart((long)br.getOffset());
        rb.stage = ResponseBuilder.STAGE_GET_FIELDS;
        boolean returnScores = (rb.getFieldFlags() & 1) != 0;
        BrowseHit[] hits = res.getHits();
        if (hits != null) {
            for (BrowseHit hit : hits) {
                SolrDocument doc = BoboFacetComponent.convert(hit, rb.rsp.getReturnFields());
                if (doc == null) continue;
                if (returnScores) {
                    doc.addField("score", (Object)Float.valueOf(hit.getScore()));
                }
                docList.add((Object)doc);
            }
        }
        rb.rsp.add("response", (Object)docList);
        if (rb.doFacets) {
            BoboFacetComponent.fillResponse(br, res, rb.rsp);
        }
        rb.stage = ResponseBuilder.STAGE_DONE;
    }

    private static SolrDocument convert(BrowseHit hit, Set<String> returnFields) {
        SolrDocument doc = new SolrDocument();
        if (returnFields != null) {
            for (String fld : returnFields) {
                Document storedFields;
                String[] fv = hit.getFields(fld);
                if (fv == null && (storedFields = hit.getStoredFields()) != null) {
                    fv = storedFields.getValues(fld);
                }
                if (fv == null) continue;
                doc.addField(fld, (Object)fv);
            }
        }
        return doc;
    }

    public void finishStage(ResponseBuilder rb) {
    }

    private static void fillResponse(BrowseRequest req, BrowseResult res, SolrQueryResponse solrRsp) {
        SimpleOrderedMap facetFieldList = new SimpleOrderedMap();
        Map facetMap = res.getFacetMap();
        Set entries = facetMap.entrySet();
        for (Map.Entry entry : entries) {
            NamedList facetList = new NamedList();
            facetFieldList.add((String)entry.getKey(), (Object)facetList);
            FacetAccessible facetAccessbile = (FacetAccessible)entry.getValue();
            List facets = facetAccessbile.getFacets();
            for (BrowseFacet facet : facets) {
                facetList.add(facet.getValue(), (Object)facet.getFacetValueHitCount());
            }
        }
        SimpleOrderedMap facetResList = new SimpleOrderedMap();
        facetResList.add("facet_fields", (Object)facetFieldList);
        SimpleOrderedMap facetQueryList = new SimpleOrderedMap();
        facetResList.add("facet_queries", (Object)facetQueryList);
        solrRsp.add("facet_counts", (Object)facetResList);
    }
}

